// Graph Realization Problem
// (PQ-graph)
// 2003/8/26
//

import java.io.*;
import java.util.*;
////////////////////////////////////////////////////////////
public class PQG{
	public static void main(String args[]){
		int i, treeSize;
		boolean graphic = true;
		ArrayList block, subblock, PQList;
		MatrixDivide md;
		PQ_graph g = null;
		
		if(args.length != 1) {
			System.out.println("Error : >java GPR [filename]");
			System.exit(1);
		}
		md = new MatrixDivide(args[0]);
		PQList = new ArrayList();
		treeSize = md.getTreeSize();
		block = md.getBlock();
		for(i=0; i<block.size(); i++) {
			subblock = (ArrayList)block.get(i);
			g = new PQ_graph(treeSize);
			PQList.add(g);
			for(int j=0; j<subblock.size(); j++) {
				if(!g.addCircuit((int[])subblock.get(j))) {
					System.out.println("NonGraphic");
					graphic = false;
					return;
				}
			}
		}
		if(graphic) {
			System.out.println("Graphic. BlockSize is " + block.size() + ".");
			for(int j=0; j<PQList.size(); j++) 
				((PQ_graph)PQList.get(j)).disp();
		}
	}
}
//////////////////////////////////////////////////////////// 
class MatrixDivide {
	int treeSize, coTreeIndex = 0;
	ArrayList block = new ArrayList();
//----------------------------------------------------------
	public MatrixDivide(String fileName) {
		int i, j, k, l, num, len;
		int[] rq;
		String s;
		StringTokenizer st;
		ArrayList[] tree;
		ArrayList coTree = new ArrayList(),
		                   queue = new ArrayList(), subBlock;
		boolean[] treeFlg, coTreeFlg;
		
		try {
			BufferedReader br = new BufferedReader(new FileReader(fileName));
			s = br.readLine();
			treeSize = Integer.parseInt(s);
			tree = new ArrayList[treeSize+1];
			for(i=0; i<=treeSize; i++){
				tree[i] = new ArrayList();
			}

			while((s = br.readLine()) != null) {
				st = new StringTokenizer(s, " ");
				num = st.countTokens();
				rq = new int[num];
				for(i=0; i<num; i++) {
					rq[i] = Integer.valueOf(st.nextToken()).intValue();
				}			
				coTree.add(rq);
				for(i=0; i<num; i++){
					tree[rq[i]].add(new Integer(coTreeIndex));
				}
				coTreeIndex++;
			}

			treeFlg = new boolean[treeSize+1];
			for(i=0; i<=treeSize; i++) {
				treeFlg[i] = false;
			}
			coTreeFlg = new boolean[coTreeIndex];
			for(i=0; i<coTreeIndex; i++) {
				coTreeFlg[i] = false;
			}
			
			for(i=0; i<coTreeIndex; i++) {
				if(coTreeFlg[i]) continue;
				coTreeFlg[i] = true;
				queue.add((int[])coTree.get(i));
				subBlock = new ArrayList();
				subBlock.add((int[])coTree.get(i));
				while(queue.size() >0) {
					rq = (int[])queue.get(0); queue.remove(0);
					for(j=0; j<rq.length; j++) {
						if(treeFlg[rq[j]]) continue;
						treeFlg[rq[j]] = true;
						for(k=0; k<tree[rq[j]].size(); k++) {
							l = ((Integer)tree[rq[j]].get(k)).intValue();
							if(coTreeFlg[l]) continue;
							coTreeFlg[l] = true;
							queue.add((int[])coTree.get(l));
							subBlock.add((int[])coTree.get(l));
						}
					}
				}
				block.add(subBlock);
			}
			
/*
 // Test for check blocked
			for(i=0; i<block.size(); i++){
				System.out.println("block " + i);
				subBlock = (ArrayList)block.get(i);
				for(j=0; j<subBlock.size(); j++) {
					rq = (int[])subBlock.get(j);
					for(k=0; k<rq.length; k++)
						System.out.print(rq[k] + " ");
					System.out.println();
				}
			}
*/	
		}
		catch(Exception e) {
			System.out.println("Execption: " +e);
		}
	}
//----------------------------------------------------------
	public ArrayList getBlock() {
		return block;
	}
//----------------------------------------------------------
	public int getTreeSize() {
		return treeSize;
	}
//----------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class PQ_graph {
	int treeEdgeSize, type, piIndex, reduceType, ps, coTreeIndex;
	static int coTreeEdgeSize;
	Node[] element;
	PQ_tree root = null, u1s, u2s, u3s, uss, vs, v1s, v2s, w1s, w2s,
	        xs, u, uh, ub, wkt, pe, qe, gamma1, gamma2;
	Node bi1s, bi2s, b, bb, b1, b2, hh, hb, b1s, b2s, h1, h2, bis;
	ArrayList piList = new ArrayList(), qiList = new ArrayList();
	NodeSet Hh = new NodeSet();
	static final int both = 3,
	             either = 4,
	             b1only = 1,
	             b2only = 2,
	             cannot = 0;
	Queue initializeTree = new Queue();

	             
	//debug
	ArrayList allTree = new ArrayList();
	ArrayList coTreeEdge = new ArrayList();
	int addCount = 0;
//--------------------------------------------------------------
	public PQ_graph(int size){
		treeEdgeSize = size;
		element = new Node[treeEdgeSize + 1];
		coTreeIndex = treeEdgeSize+1;
		coTreeEdgeSize = coTreeIndex;
		
	}
//--------------------------------------------------------------
/*
	public void dispAll() { // debug
		int i;
		PQ_tree t;
		
		System.out.println("Disp All:");
		for(i=0; i<allTree.size(); i++) {
			t = (PQ_tree)allTree.get(i);
			t.dispAll();
			System.out.println("");
		}
		System.out.println("");
	}
*/
//--------------------------------------------------------------
	public void disp() {
		int i;
		ArrayList graphList;
		int[] edgeA;
		
		graphList = getGraph();
		for(i=0; i<graphList.size(); i++) {
			edgeA = (int[])graphList.get(i);
			System.out.println(edgeA[0] + ":(" +edgeA[1] + ", " + edgeA[2] + ")");
		}
	}
//--------------------------------------------------------------
	public ArrayList getGraph() {
		int i, nodeCount = 0;
		PQ_tree wkt;
		Node wkn, wkb;
		ArrayList graphList = new ArrayList();
		int[] edgeA;
		
		for(i=0; i<allTree.size(); i++) {
			wkt = (PQ_tree)allTree.get(i);
			wkt.setPermutation(element);
		}//dispAll();
		for(i=1; i < element.length; i++) {
			wkn = element[i];
			if(wkn == null) {continue;}
			edgeA = new int[3];
			edgeA[0] = i;
			wkb = wkn.immediateSiblings.get(0);
			if(wkb.name == Node.head) {wkb = wkb.getAdjacentBVertex();}
			if(wkb.nodeNameForGraph == 0) 
				{wkb.nodeNameForGraph = ++nodeCount;}
			edgeA[1] = wkb.nodeNameForGraph;
			wkb = wkn.immediateSiblings.get(1);
			if(wkb.name == Node.head) {wkb = wkb.getAdjacentBVertex();}
			if(wkb.nodeNameForGraph == 0) 
				{wkb.nodeNameForGraph = ++nodeCount;}
			edgeA[2] = wkb.nodeNameForGraph;
			graphList.add(edgeA);
		}
		for(i=0; i<coTreeEdge.size(); i++) {
			wkt = (PQ_tree)coTreeEdge.get(i);
			edgeA = new int[3];
			edgeA[0] = coTreeEdgeSize++;
			wkb = wkt.root.endmostChildren.get(0);
			if(wkb.name == Node.head) {wkb = wkb.getAdjacentBVertex();}
			edgeA[1] = wkb.nodeNameForGraph;
			wkb = wkt.root.endmostChildren.get(1);
			if(wkb.name == Node.head) {wkb = wkb.getAdjacentBVertex();}
			edgeA[2] = wkb.nodeNameForGraph;
			graphList.add(edgeA);
		}
		return graphList;
	}
//----------------------------------------------------------
	public boolean addCircuit(int[] rq){ // OK
		int i,j,k, sigmaSize=0;
		int[] sigma, pi;
		Node wkn;
		PQ_tree wkt;
		
		//System.out.println("Line " + (++addCount)); // debug
		if(root == null) {
			root = new PQ_tree(rq, element);
			allTree.add(root);
			coTreeEdge.add(root);
			return true;
		}
		for(i=0; i<rq.length; i++) {
			if(element[rq[i]] == null) {sigmaSize++;}
		}
		sigma = new int[sigmaSize];
		pi = new int[rq.length - sigmaSize];
		j=k=0;
		for(i=0; i<rq.length; i++) {
			wkn = element[rq[i]];
			if(wkn == null) {
				sigma[k++] = rq[i];
			} else {
				pi[j++] = rq[i];
				wkn.pqTree.uij.add(wkn);
				wkn.inS = true;
			}
		}
		if( !findPath(pi) || !reduce() ) {return false;} 
		wkt = new PQ_tree(sigma, pi, bi1s, bi2s, element);
		allTree.add(wkt);
		coTreeEdge.add(wkt);
		initialize();
		return true;
	}
//--------------------------------------------------------------
	private void initialize() { // OK
		int i;
		PQ_tree t;
		bi1s = bi2s = null;
		u1s = u2s = w1s = w2s = null;
		piList.clear();
		qiList.clear();
		while(initializeTree.size() > 0) {
			t = (PQ_tree)initializeTree.deQueue();
			t.inK = 0;
			t.inSCount = 0;
			t.consHS.clear();
			t.consType = -1;
			for(i=0; i<t.uij.size(); i++) {
				((Node)t.uij.get(i)).inS = false;
			}
			t.uij.clear();
			if(t.l != 0) {
				t.unionHead(t.head1);
				t.unionHead(t.head2);
			}
		}
	}
//--------------------------------------------------------------
	private boolean findPath(int[] rq){
		int i, j, ls, di, kCount;
		boolean qs, bln1, bln2;
		Node wkh;
		PQ_tree wk, u, piEnd, qiEnd;
		PQ_tree[] piNext = new PQ_tree[2], qiNext = new PQ_tree[2];
		ArrayList kList = new ArrayList(), wkList;
		NodeSet consHS;
		
		xs = null;
		// (1)
		for(i=0; i<rq.length; i++) {
			if(element[rq[i]].pqTree.inK == 0) {
				element[rq[i]].pqTree.inK = 1;
				initializeTree.enQueue(element[rq[i]].pqTree);
				kList.add(element[rq[i]].pqTree);
			}
		}
		
		u1s = (PQ_tree)kList.get(0);
		ls = u1s.l;
		for(i=1; i<kList.size(); i++) {
			wk = (PQ_tree)kList.get(i);
			if(wk.l > u1s.l) {u1s = wk;}
			if(wk.l < ls) {ls = wk.l;}
		}
		piList = new ArrayList();
		piList.add(u1s);
		type = 0;
		qs = false;
		
		// (2)
		u = u1s;
		u.setConsecutiveHead();
		while(u.l > ls) {//System.out.println("(2in)"+u.treeName);
			setdip(u);
			if(u.consType == 0) {return false;}
			if(u.consType == 1) {
				if(!checkElement(u, kList)) {return false;}
				type = 1;
				break;
			}//System.out.println(u.consHS.size());
			if(u.consHS.size() == 0) {return false;}
			else if(u.consHS.size() == 1) {
				wkh = u.consHS.get(0);
				u = nextNode(piList, wkh.getAdjacentTree(), u);
				u.setConsecutiveHead(wkh.getAdjacentBVertex());
			} else {
				if(u.dip == 1) {
					gamma1.setConsecutiveHead(u);
					u = nextNode(piList, gamma1, u);
				}	else {//System.out.println(u.checkExactConsecutive(b1));
					if(gamma1.checkExactConsecutive(b1)
				     || gamma1.checkHeadConsecutive(b1) 
				     || (gamma1.l == ls && gamma2.inK == 0 && gamma1.checkConsecutive(b1))) {
				  	wkh = u.getHead(gamma1);
				  	u = nextNode(piList, gamma1, u);
				  }	else {//if(gamma2.l >= ls){
				  	wkh = u.getHead(gamma2);
				  	u = nextNode(piList, gamma2, u);
				  }// else {break;}
					u.setConsecutiveHead(wkh.getAdjacentBVertex());
				}
			}
		}//System.out.println("(2out)"+u.treeName);
		uss = u;
		uss.inK = 2;
		
		
		// (3)		
		for(i = kList.size(); i > 0; i--) {
			wkt = (PQ_tree)kList.get(i-1);
			if(wkt.inK >= 2) {kList.remove(i-1);}
		}
		if(kList.size() == 0) {return true;}
		
		u2s = (PQ_tree)kList.get(0);
		for(i=1; i<kList.size(); i++) {
			wkt = (PQ_tree)kList.get(i);
			if(wkt.l > u2s.l) {u2s = wkt;}
		}
		
		qiList = new ArrayList();
		qiList.add(u2s);
		u = u2s;
		u.setConsecutiveHead();
		while(u.l > ls) {//System.out.println("(3in)"+u.treeName);
			setdip(u);
			if(u.consType == 0) {return false;}
			if(u.consType == 1) {return false;}
			if(u.consHS.size() == 0) {
				return false;
			} else if(u.consHS.size() == 1) {
				wkh = u.consHS.get(0);
				u = nextNode(qiList, wkh.getAdjacentTree(), u);
				u.setConsecutiveHead(wkh.getAdjacentBVertex());
			} else {
				if(u.dip == 1) {
					gamma1.setConsecutiveHead(u);
					u = nextNode(qiList, gamma1, u);
				}	else {
					if(gamma1.checkExactConsecutive(b1)
				     || gamma1.checkHeadConsecutive(b1)) {
				  	wkh = u.getHead(gamma1);
				  	u = nextNode(qiList, gamma1, u);
				  } else if(gamma2.inK == 1) {
				  	wkh = u.getHead(gamma2);
				  	u = nextNode(qiList, gamma2, u);
				  } else if(gamma1 == uss || gamma1.checkConsecutive(b1)) {
				  	wkh = u.getHead(gamma1);
				  	u = nextNode(qiList, gamma1, u);
				  }	else {//if(gamma2.l >= ls) {
				  	wkh = u.getHead(gamma2);
				  	u = nextNode(qiList, gamma2, u);
				  } //else {break;}
					u.setConsecutiveHead(wkh.getAdjacentBVertex());
				}
			}
			if(u.inK == 2) {
				xs = u;
				break;
			}
			if(u.inK == 3) {return false;}
		}//System.out.println("(3out)"+u.treeName);
		u.inK = 2;
		for(i = kList.size(); i > 0; i--) {
			if(((PQ_tree)kList.get(i-1)).inK == 2) {kList.remove(i-1);}
		}
		if(kList.size() == 0) {
			if(xs != null) {
				v1s = (PQ_tree)piList.get(piList.indexOf(xs)-1);
				v2s = (PQ_tree)qiList.get(qiList.indexOf(xs)-1);
				type += 2; 
			} else {
				if(type == 1) {return false;}
				piEnd = (PQ_tree)piList.get(piList.size()-1);
				qiEnd = (PQ_tree)qiList.get(qiList.size()-1);
				if(piEnd.l != 0) {
					setdip(piEnd);
					piNext[0] = piEnd.getAdjacentTree(1);
					piNext[1] = piEnd.getAdjacentTree(2);
				} else {
					piNext[0] = piNext[1] = null;
				}
				if(qiEnd.l != 0) {
					setdip(qiEnd);
					qiNext[0] = qiEnd.getAdjacentTree(1);
					qiNext[1] = qiEnd.getAdjacentTree(2);
				} else {
					qiNext[0] = qiNext[1] = null;
				}
				while(piEnd != qiEnd) {//System.out.println(piEnd.treeName+" "+qiEnd.treeName);
					for(i=0; i<2; i++) {
						if(piNext[i] == qiEnd) {
							piEnd = nextNode(piList, qiEnd, piEnd);
							i = 3;
						}
					}
					if(i > 2) {break;}
					for(i=0; i<2; i++) {
						if(qiNext[i] == piEnd) {
							qiEnd = nextNode(qiList, piEnd, qiEnd);
							i = 3;
						}
					}
					if(i > 2) {break;}
					for(i=0; i<2; i++) for(j=0; j<2; j++) {
						if(piNext[i] == qiNext[j]) {
							piEnd = nextNode(piList, piNext[i], piEnd);
							qiEnd = nextNode(qiList, qiNext[j], qiEnd);
							i = j = 3;// loop out
						}
					}
					if(i > 2) {break;}
					if(piEnd.l > qiEnd.l || (piEnd.l == qiEnd.l && piNext[0].isTwoTerminal)) {
						if(piNext[0] == qiEnd || piNext[1] == qiEnd) 
							{piEnd = nextNode(piList, qiEnd, piEnd);}
						else if(piEnd.dip == 1) {piEnd = nextNode(piList, piNext[0], piEnd);}
						else {
							if(piNext[0].l > piNext[1].l || (piNext[0].l == piNext[1].l && piNext[1].isTwoTerminal))
								{piEnd = nextNode(piList, piNext[1], piEnd);}
							else {piEnd = nextNode(piList, piNext[0], piEnd);}
						}
						if(piEnd.l != 0) {
							setdip(piEnd);
							piNext[0] = piEnd.getAdjacentTree(1);
							piNext[1] = piEnd.getAdjacentTree(2);
						} else {piNext[0] = piNext[1] = null;}
					} else {
						if(qiNext[0] == piEnd || qiNext[1] == piEnd) 
							{qiEnd = nextNode(qiList, piEnd, qiEnd);}
						else if(qiEnd.dip == 1) {qiEnd = nextNode(qiList, qiNext[0], qiEnd);}
						else {
							if(qiNext[0].l > qiNext[1].l || (qiNext[0].l == qiNext[1].l && qiNext[1].isTwoTerminal)) 
								{qiEnd = nextNode(qiList, qiNext[1], qiEnd);}
							else {qiEnd = nextNode(qiList, qiNext[0], qiEnd);}
						}
						if(qiEnd.l != 0) {
							setdip(qiEnd);
							qiNext[0] = qiEnd.getAdjacentTree(1);
							qiNext[1] = qiEnd.getAdjacentTree(2);
						} else {qiNext[0] = qiNext[1] = null;}
					}
				}
				v1s = (PQ_tree)piList.get(piList.size()-2);
				v2s = (PQ_tree)qiList.get(qiList.size()-2);
				type = 6;
				xs = piEnd;
				if(v1s.dip != 1 && v2s.dip != 1) {
					if(v2s.getHead(v1s.getAdjacentBVertex(1)) != null &&
					   v2s.getHead(v1s.getAdjacentBVertex(2)) != null) {
						w1s = v1s.getAdjacentTree(1);
						w2s = v1s.getAdjacentTree(2);
						type = 7;
					}
				}
			}
		} else {
			if(xs == null) {return false;}
			u3s = (PQ_tree)kList.get(0);
			for(i=1; i<kList.size(); i++) {
				wkt = (PQ_tree)kList.get(i);
				if(wkt.l > u3s.l) {u3s = wkt;}
			}
			v1s = (PQ_tree)piList.get(piList.indexOf(xs)-1);
			v2s = (PQ_tree)qiList.get(qiList.indexOf(xs)-1);
			if(v1s.consHS.size() == 2 && v1s.getHead(u3s) != null
			   && u3s.checkExactConsecutive(v1s.getAdjacentBVertex(u3s))) {
				if(!checkElement(v1s, kList)) {return false;}
				if(xs.getHead(v1s.getAdjacentBVertex(u3s)) != null) {
					uss = xs;
					type = 3;
				} else {
					if(v2s.consHS.size() == 2 && v2s.getHead(u3s) != null
					   && u3s.checkExactConsecutive(v2s.getAdjacentBVertex(u3s))) {
						w1s = xs;
						w2s = u3s;
						type = 5;
					} else {
						w1s = u3s;
						w2s = xs;
						type = 4;
					}
				}
			} else if(v2s.consHS.size() == 2 && v2s.getHead(u3s) != null
			   && u3s.checkExactConsecutive(v2s.getAdjacentBVertex(u3s))) {
				if(!checkElement(v2s, kList)) {return false;}
				if(xs.getHead(v2s.getAdjacentBVertex(u3s)) != null) {
					uss = xs;
					type = 3;
				} else {
					wkList = piList; piList = qiList; qiList = wkList;
					wkt = v1s; v1s = v2s; v2s = wkt;
					w1s = u3s;
					w2s = xs;
					type = 4;
				}
			} else {
				u = xs;
				while(u.dip == 1) {u = u.getAdjacentTree(1);}
				if(u.l != 0 && !checkElement(u, kList)) {return false;}
				uss = u;
				type = 3;
			}
			if(piList.contains(xs))
				for(i=piList.indexOf(xs)+1; i<piList.size(); i++) {
					wkt = (PQ_tree)piList.get(i);
					if(wkt.uij.size() != wkt.inSCount) {return false;}
				}
			if(qiList.contains(xs)) 
				for(i=qiList.indexOf(xs)+1; i<qiList.size(); i++) {
					wkt = (PQ_tree)qiList.get(i);
					if(wkt.uij.size() != wkt.inSCount) {return false;}
				}
			for(i = kList.size(); i > 0; i--) {
				wkt = (PQ_tree)kList.get(i-1);
				if(wkt.inK >= 2) {kList.remove(i-1);}
			}
			if(kList.size() != 0) {return false;}
		}
		return true;
	}
//--------------------------------------------------------------
	private void setdip(PQ_tree t) {
		PQ_tree wkt;
		
		gamma1 = t.getAdjacentTree(1);
		gamma2 = t.getAdjacentTree(2);
		if(gamma1 == gamma2) {t.dip = 1;}
		else {t.dip = 2;}
		if(gamma1.l > gamma2.l || (gamma1.l == gamma2.l && gamma2.isTwoTerminal)) {
			b1 = t.getAdjacentBVertex(1);
			b2 = t.getAdjacentBVertex(2);
		} else {
			wkt = gamma1;
			gamma1 = gamma2;
			gamma2 = wkt;
			b1 = t.getAdjacentBVertex(2);
			b2 = t.getAdjacentBVertex(1);
		}
	}
//--------------------------------------------------------------
	private PQ_tree nextNode(ArrayList list, PQ_tree gamma, PQ_tree u) {
		list.add(gamma);
		u.inK = 2;	
		initializeTree.enQueue(gamma);
		return gamma;
	}
//--------------------------------------------------------------
	private boolean checkElement(PQ_tree t, ArrayList kList) {
		int i;
		Node wkn;
		PQ_tree wkt;
		
		for(i=0; i<t.pi.length; i++) {
			wkn = element[t.pi[i]];
			if(!wkn.inS) {return false;}
			wkn.pqTree.inSCount++;
		}
		for(i=0; i<kList.size(); i++) {
			wkt = (PQ_tree)kList.get(i);
			if(wkt.l < t.l) {
				if(wkt.uij.size() != wkt.inSCount) {return false;}
				wkt.inK = 3;
			}
		}
		return true;
	}
//--------------------------------------------------------------
	private boolean reduce() {
		int i, j, extendType;
		Node wkNode, wkh, v1n1, v1n2, v2n1, v2n2, wkb;
		PQ_tree wkTree, t;
		ArrayList wkList;
		NodeSet bns1 = new NodeSet(), bns2 = new NodeSet(), bns = new NodeSet();
		boolean wkbln;
		
		bi1s = null;
		bi2s = null;
		t = null;
		/*
		System.out.println(type);
		System.out.print("piList:");
		for(i=0; i<piList.size(); i++) {
			System.out.print(((PQ_tree)piList.get(i)).treeName +"-->");
		}
		System.out.println("");
		System.out.print("qiList:");
		for(i=0; i<qiList.size(); i++) {
			System.out.print(((PQ_tree)qiList.get(i)).treeName +"-->");
		}
		System.out.println("");
		*/
		switch(type) {
			case 1:
				uss.uij.add(uss.getHead(1));
				uss.uij.add(uss.getHead(2));
				
			case 0:
				extendType = pathExtend(uss, u1s, piList);//System.out.println("extendType:"+extendType);
				if(extendType == 0) {return false;}
				if(extendType == 1) {
					if(!u1s.reduction(this)) {return false;}
				} else {
					if(!uh.reduction(Hh)) {return false;}
					if(ps == 2) {
						hh = uh.headFix();
						if(hb == null) {
							ub.reduction(hh);
							bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
							if(bi1s == null) {return false;}
						}
						else if(!ub.reduction(hh, hb)) {return false;}
						Hh.set(hh);
					}
					bi2s = uh.insertEndnode(Hh);
					if(bi2s == null) {return false;}
				}
				return true;
				
			case 3:
				uss.uij.add(uss.getHead(1));
				uss.uij.add(uss.getHead(2));
				
			case 2:
				extendType = pathExtend(uss, xs, piList);
				if(extendType == 0) {return false;}
				resetUnion(v1s, xs);
				resetUnion(v2s, xs);
				if(extendType == 1) {
					if(v1s.dip == 1 && xs.reductionCheckBoth(v1s) &&
					   v2s.dip == 1 && xs.reductionCheckBoth(v2s) )
						{return pathExtend(v1s, v2s, true);}
					if(v1s.dip == 1 && xs.reductionCheckBoth(v1s)) {
						wkTree = v1s; v1s = v2s; v2s = wkTree;
						wkList = piList; piList = qiList; qiList = wkList;
					}
					if(v1s.dip == 1) {//System.out.println(v1s.treeName);
						switch(xs.reduction(v1s)) {
							case cannot:
								return false;
							case b1only:
								b1s = v1s.getAdjacentBVertex(1);
								break;
							case b2only:
								b1s = v1s.getAdjacentBVertex(2);
								break;
							case either:
								Hh.clear();
								Hh.add(v1s.getHead(1));
								Hh.add(v1s.getHead(2));
								if(v1s.uij.size() != 0) {
									if(!v1s.reduction(Hh)) {return false;}
									hh = v1s.headFix();
								} else {
									hh = v1s.headFix((PQ_tree)piList.get(piList.indexOf(v1s)-1));
								}
								if(!xs.reduction(hh)) {return false;}
								b1s = hh.getAdjacentBVertex();
								break;
						}
					} else {
						b1s = v1s.getAdjacentBVertex(xs);
					}
					if(v2s.dip == 1) {//System.out.println("v2s:"+v2s.treeName+", b1s:"+b1s.nodeName);
						switch(xs.reduction(v2s, b1s)) {
							case cannot:
								return false;
							case b1only:
								b2s = v2s.getAdjacentBVertex(1);
								break;
							case b2only:
								b2s = v2s.getAdjacentBVertex(2);
								break;
							case either:
								Hh.clear();
								Hh.add(v2s.getHead(1));
								Hh.add(v2s.getHead(2));
								if(v2s.uij.size() != 0) {
									if(!v2s.reduction(Hh)) {return false;}
									hh = v2s.headFix();
								} else {
									hh = v2s.headFix((PQ_tree)qiList.get(qiList.indexOf(v2s)-1));
								}
								if(!xs.reduction(hh, b1s)) {return false;}
								b2s = hh.getAdjacentBVertex();
								break;
						}
					} else { // v2s.dip == 2
						if(v2s.getAdjacentTree(1) == xs) {wkh = v2s.getHead(1);}
						else {wkh = v2s.getHead(2);}
						if(!xs.reduction(wkh, b1s)) {return false;}
						b2s = wkh.getAdjacentBVertex();
					}
					return pathExtend(b1s, v1s, b2s, v2s);
				} else { // extendType == 2
					if(bi1s == null) {return false;}
					b1s = bi1s;
					if(v1s.getHead(bi1s) == null && v2s.getHead(bi1s) == null) {return false;}
					if(v1s.getHead(bi1s) != null && v2s.getHead(bi1s) != null) {
						if(!xs.reduction(Hh)) {return false;}
						if(ps == 2) {
							hh = uh.headFix();
							ub.reduction(hh);
							if(!ub.reduction(hh, hb)) {return false;}
							Hh.set(hh);
						}
						b2s = uh.insertEndnode(Hh);
						if(b2s == null) {return false;}
						if(v1s.getHead(b2s) != null && v2s.getHead(b2s) != null) 
							{return pathExtend(v1s, v2s, true);}
						else if(v2s.getHead(b2s) != null)	{
							return pathExtend(b1s, v1s, hh.getAdjacentBVertex(), xs);}
						else if(v1s.getHead(b2s) != null)	{
							return pathExtend(hh.getAdjacentBVertex(), xs, b1s, v2s);}
						else {return false;}
					}
					b2s = Hh.get(0).getAdjacentBVertex();
					
					if(v1s.getHead(bi1s) != null && v2s.getHead(bi1s) == null)
						{return pathExtend(b1s, v1s, b2s, xs);}
					else
						{return pathExtend(b2s, xs, b1s, v2s);}
				}
				
			case 4:
				b1s = v1s.getAdjacentBVertex(w1s);
				b2s = w2s.getNearestHead(v1s.getAdjacentBVertex(w2s)).getAdjacentBVertex();
				return pathExtend(b1s, v1s, b2s, w2s);
				
			case 5:
				return pathExtend(v1s, v2s, true);
				
			case 6://System.out.println("v1s:"+v1s.treeName+", v2s:"+v2s.treeName+", xs:"+xs.treeName);
				resetUnion(v1s, xs);
				resetUnion(v2s, xs);
				if(v1s.getHead(v2s.getAdjacentBVertex(1)) != null 
				   && v1s.getHead(v2s.getAdjacentBVertex(2)) != null)
					{return pathExtend(v1s, v2s, false);}
				else if(v1s.getHead(v2s.getAdjacentBVertex(1)) != null)
					{return pathExtend(v2s.getAdjacentBVertex(1), v1s, v2s.getAdjacentBVertex(1), v2s);}
				else if(v1s.getHead(v2s.getAdjacentBVertex(2)) != null)
					{return pathExtend(v2s.getAdjacentBVertex(2), v1s, v2s.getAdjacentBVertex(2), v2s);}
				else {
					bns1 = getStartNodeSet(v1s, piList);
					bns2 = getStartNodeSet(v2s, qiList);
					if(bns1 == null || bns2 == null) {return false;}
					if(bns1.size() == 0 || bns2.size() == 0) {return false;}
					wkb = xs.getStartNode(v1s, bns1, v2s, bns2);
					if(wkb == null) {return false;}
					return pathExtend(wkb, v1s, wkb, v2s);
				}
				
			case 7:
				return pathExtend(v1s, v2s, false);
		}
		return false;
	}
//--------------------------------------------------------------
	private int pathExtend(PQ_tree start, PQ_tree goal, ArrayList list) {
		int i, j, listIndex;
		Node wkh;
		listIndex = list.indexOf(start);
		u = start;
		hb = null;
		while(true){//System.out.println(u.treeName);
			if(u == goal) {return 1;}
			uh = u;
			u = (PQ_tree)list.get(--listIndex);
			resetUnion(u, uh);//System.out.println(u.treeName+ " " +u.dip);
			if(u.dip == 1) {
				reduceType = uh.reduction(u);//System.out.println(uh.treeName+ " " +reduceType);
				if(reduceType == cannot) {return 0;}
				if(reduceType == both) {
					u.uij.add(u.getHead(1));
					u.uij.add(u.getHead(2));
					hb = null;
					continue;
				}
				if(reduceType == either) {ps = 2;}
				else {
					ps = 1;
					if(reduceType == b1only) {b = u.getAdjacentBVertex(1);}
					else if(reduceType == b2only) {b = u.getAdjacentBVertex(2);}
					bi1s = uh.insertEndnode(b);
					if(bi1s == null) {return 0;}
				}
			}
			if(u.dip == 2) {
				wkh = u.getHead(uh);
				if(!uh.reduction(wkh)) {return 0;}
				b = wkh.getAdjacentBVertex();
				bi1s = uh.insertEndnode(b);
				if(bi1s == null) {return 0;}
				ps = 1;
			}
			while(true) {
				Hh.clear();
				if(ps == 1){
					Hh.add(u.getHead(b));
					hh = Hh.get(0);
				} else {
					Hh.add(u.getHead(1));
					Hh.add(u.getHead(2));
				}
				ub = uh;
				uh = u;
				if(uh == goal) {return 2;}
				u = (PQ_tree)list.get(--listIndex);
				if(u.dip == 1) {
					reduceType = uh.reduction(u, Hh);//System.out.println(uh.treeName+ " " +reduceType);
					if(reduceType == cannot) {return 0;}
					if(ps == 2) {
						if(uh.uij.size() != 0) {hh = uh.headFix();}
						else {hh = uh.headFix(u);}
						if(hb == null) {
							if(!ub.reduction(hh)) {return 0;}
							bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
							if(bi1s == null) {return 0;}
						}
						else if(!ub.reduction(hh, hb)) {return 0;}
						ps = 1;
					}
					if(reduceType == b1only) {b = u.getAdjacentBVertex(1);}
					else if(reduceType == b2only) {b = u.getAdjacentBVertex(2);}
					else {ps = 2;}
					if(uh.uij.size() == 0 && ps == 1) {uh.reduction(u.getHead(b), hh);}
				}
				if(u.dip == 2) {
					if(u.getHead(bi1s) != null) {
						if(!uh.reduction(Hh)) {return 0;}
						if(ps == 2) {
							hh = uh.headFix();
							if(!ub.reduction(hh, hb)) {return 0;}
							Hh.set(hh);
						}
						b1 = uh.insertEndnode(Hh);
						if(b1 == null) {return 0;}
						if(u.getHead(b1) != null) {
							u.uij.add(u.getHead(1));
							u.uij.add(u.getHead(2));
							bi1s = null;
							hb = null;
							break;
						} else {
							b = bi1s;
							bi1s = b1;
							ps = 1;
						}
					} else {
						wkh = u.getHead(uh);
						if(!uh.reduction(Hh, wkh)) {return 0;}
						b = wkh.getAdjacentBVertex();
						if(ps == 2) {
							if(uh.uij.size() != 0) {hh = uh.headFix();}
							else {hh = uh.headFix(b);}
							if(hb == null) {
								bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
								if(bi1s == null) {return 0;}
							}
							else if(!ub.reduction(hh, hb)) {return 0;}
							ps = 1;
						}
					}
				}
				hb = hh;
			}
		}
	}
//--------------------------------------------------------------
	private boolean pathExtend(Node b1s, PQ_tree v1s, Node b2s, PQ_tree v2s) {
		if(qiList.get(0) == u2s)
			{return pathExtend1(b2s, v2s, qiList) && pathExtend2(b1s, v1s, piList);}
		else if(piList.get(0) == u2s)
			{return pathExtend1(b1s, v1s, piList) && pathExtend2(b2s, v2s, qiList);}
		else {return false;}
	}
//--------------------------------------------------------------
	private boolean pathExtend1(Node bs, PQ_tree start, ArrayList list) {

		int i, j, listIndex, extendType;
		Node wkh, en;
		PQ_tree goal;
		
		listIndex = list.indexOf(start);
		uh = start;
		hb = null;
		goal = (PQ_tree)list.get(0);
		Hh.clear();
		ps = 1;
		hh = uh.getHead(bs);
		Hh.add(hh);
		while(true) {
			if(uh == goal) {
				if(!uh.reduction(Hh)) {return false;}
				if(ps == 2) {
					hh = uh.headFix();
					if(!ub.reduction(hh, hb)) {return false;}
					Hh.set(hh);
				}
				bi1s = uh.insertEndnode(Hh);
				if(bi1s == null) {return false;}
				return true;
			}
			u = (PQ_tree)list.get(--listIndex);
			if(u.dip == 1) {
				reduceType = uh.reduction(u, Hh);
				if(reduceType == cannot) {return false;}
				if(ps == 2) {
					if(uh.uij.size() != 0) {hh = uh.headFix();}
					else {hh = uh.headFix(u);}
					if(!ub.reduction(hh, hb)) {return false;}
					ps = 1;
				}
				if(reduceType == b1only) {b = u.getAdjacentBVertex(1);}
				else if(reduceType == b2only) {b = u.getAdjacentBVertex(2);}
				else {ps = 2;}
				if(uh.uij.size() == 0 && ps == 1) {uh.reduction(u.getHead(b), hh);}
			}
			if(u.dip == 2) {
				wkh = u.getHead(uh);
				b = wkh.getAdjacentBVertex();
				if(!uh.reduction(Hh, wkh)) {return false;}
				if(ps == 2) {
					if(uh.uij.size() != 0) {hh = uh.headFix();}
					else {hh = uh.headFix(b);}
					if(!ub.reduction(hh, hb)) {return false;}
					ps = 1;
				}
			}
			hb = hh;
			Hh.clear();
			if(ps == 1){
				Hh.add(u.getHead(b));
				hh = Hh.get(0);
			} else {
				Hh.add(u.getHead(1));
				Hh.add(u.getHead(2));
			}
			ub = uh;
			uh = u;
		}
	}
//--------------------------------------------------------------
	private boolean pathExtend2(Node bs, PQ_tree start, ArrayList list) {
		int i, j, listIndex;
		Node wkh;
		PQ_tree goal;
		
		listIndex = list.indexOf(start);
		u = start;
		hb = null;
		goal = (PQ_tree)list.get(0);
		Hh.clear();
		//System.out.println("bi1s: "+bi1s.nodeName);
		if(u.getHead(bi1s) == null) {
			b = bs;
			ps = 1;
		} else {
			ps = 2;
			u.uij.add(u.getHead(1));
			u.uij.add(u.getHead(2));
			bi1s = null;
		}
		while(true){//System.out.println(u.treeName);
			if(bi1s == null) {
				if(u == goal) {return goal.reduction(this);}
				uh = u;
				u = (PQ_tree)list.get(--listIndex);
				resetUnion(u, uh);//System.out.println(u.treeName+ " " +u.dip);
				if(u.dip == 1) {
					reduceType = uh.reduction(u);//System.out.println(uh.treeName+ " " +reduceType);
					if(reduceType == cannot) {return false;}
					if(reduceType == both) {
						u.uij.add(u.getHead(1));
						u.uij.add(u.getHead(2));
						hb = null;
						continue;
					}
					if(reduceType == either) {ps = 2;}
					else {
						ps = 1;
						if(reduceType == b1only) {b = u.getAdjacentBVertex(1);}
						else if(reduceType == b2only) {b = u.getAdjacentBVertex(2);}
						bi1s = uh.insertEndnode(b);
						if(bi1s == null) {return false;}
					}
				}
				if(u.dip == 2) {
					wkh = u.getHead(uh);
					if(!uh.reduction(wkh)) {return false;}
					b = wkh.getAdjacentBVertex();
					bi1s = uh.insertEndnode(b);
					if(bi1s == null) {return false;}
					ps = 1;
				}
			}
			while(true) {
				Hh.clear();
				if(ps == 1){
					Hh.add(u.getHead(b));
					hh = Hh.get(0);
				} else {
					Hh.add(u.getHead(1));
					Hh.add(u.getHead(2));
				}
				ub = uh;
				uh = u;
				if(uh == goal) {
					if(!uh.reduction(Hh)) {return false;}
					if(ps == 2) {
						hh = uh.headFix();
						if(hb == null) {
							ub.reduction(hh);
							bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
							if(bi1s == null) {return false;}
						}
						else if(!ub.reduction(hh, hb)) {return false;}
						Hh.set(hh);
					}
					bi2s = uh.insertEndnode(Hh);
					if(bi2s == null) {return false;}
					return true;
				}
				u = (PQ_tree)list.get(--listIndex);
				//resetUnion(u, uh);
				if(u.dip == 1) {
					reduceType = uh.reduction(u, Hh);//System.out.println(uh.treeName+ " " +reduceType);
					if(reduceType == cannot) {return false;}
					if(ps == 2) {
						if(uh.uij.size() != 0) {hh = uh.headFix();}
						else {hh = uh.headFix(u);}
						if(hb == null) {
							if(!ub.reduction(hh)) {return false;}
							bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
							if(bi1s == null) {return false;}
						}
						else if(!ub.reduction(hh, hb)) {return false;}
						ps = 1;
					}
					if(reduceType == b1only) {b = u.getAdjacentBVertex(1);}
					else if(reduceType == b2only) {b = u.getAdjacentBVertex(2);}
					else {ps = 2;}
					if(uh.uij.size() == 0 && ps == 1) {uh.reduction(u.getHead(b), hh);}
				}
				if(u.dip == 2) {
					if(u.getHead(bi1s) != null) {
						if(!uh.reduction(Hh)) {return false;}
						if(ps == 2) {
							hh = uh.headFix();
							if(!ub.reduction(hh, hb)) {return false;}
							Hh.set(hh);
						}
						b1 = uh.insertEndnode(Hh);
						if(b1 == null) {return false;}
						if(u.getHead(b1) != null) {
							u.uij.add(u.getHead(1));
							u.uij.add(u.getHead(2));
							bi1s = null;
							hb = null;
							break;
						} else {
							b = bi1s;
							bi1s = b1;
							ps = 1;
						}
					} else {
						wkh = u.getHead(uh);
						if(!uh.reduction(Hh, wkh)) {return false;}
						b = wkh.getAdjacentBVertex();
						if(ps == 2) {
							if(uh.uij.size() != 0) {hh = uh.headFix();}
							else {hh = uh.headFix(b);}
							if(hb == null) {
								bi1s = ub.insertEndnode(hh.getAdjacentBVertex());
								if(bi1s == null) {return false;}
							}
							else if(!ub.reduction(hh, hb)) {return false;}
							ps = 1;
						}
					}
				}
				hb = hh;
			}
		}
	}
//--------------------------------------------------------------
	private boolean pathExtend(PQ_tree v1, PQ_tree v2, boolean pinch) {
		PQ_tree t, wkTree, uh, u;
		Node b, b1, b2, hh, wkh, b1e = null, b2e = null;
		NodeSet Hh = new NodeSet(), bns1, bns2;
		ArrayList wkList, s = new ArrayList();
		
		
		if(v1.getHead(1).isPChild() && v2.getHead(1).isPChild()) {
			t = new PQ_tree(v1, v2);
			initializeTree.enQueue(t);
			allTree.add(t);
			if(pinch)
				{return pathExtend(v1.getAdjacentBVertex(1), v1, v1.getAdjacentBVertex(2), v2);}
			else
				{return pathExtend(v1.getAdjacentBVertex(1), v1, v1.getAdjacentBVertex(1), v2);}
		}
		
		bns1 = getStartNodeSet(v1, piList);
		bns2 = getStartNodeSet(v2, qiList);
		if(bns1 == null || bns2 == null) {return false;}
		if(bns1.size() == 0 || bns2.size() == 0) {return false;}

		if(bns1.size() == 1) {
			b1e = bns1.get(0);
			if(bns2.size() == 1) {b2e = bns2.get(0);}
			else {
				b1 = v2.getAdjacentBVertex(1);
				b2 = v2.getAdjacentBVertex(2);
				if(b1e == b1) {b2e = pinch? b2 : b1;}
				else if(b1e == b2) {b2e = pinch? b1 : b2;}
				else {
					b1e.name = b1.name = b2.name = 0;
					s.add(0, b1e);
					s.add(0, b1);
					if(b1e.pqTree.reductionCheck(s)) {
						b1.pqTree.addNeutral(v2);
						b1e.name = b1.name = b2.name = Node.bVertex;
						b1 = v2.getAdjacentBVertex(1);
						b2 = v2.getAdjacentBVertex(2);
						b2e = pinch? b2 : b1;
					} else if(b1e.pqTree.reductionCheck(s)) {
						s.remove(0);
						s.add(0, b2);
						b1.pqTree.addNeutral(v2);
						b1e.name = b1.name = b2.name = Node.bVertex;
						b1 = v2.getAdjacentBVertex(1);
						b2 = v2.getAdjacentBVertex(2);
						b2e = pinch? b1 : b2;
					} else {return false;}
					s.clear();
				}
			}
		} else if(bns2.size() == 1) {
			b2e = bns2.get(0);
			b1 = v1.getAdjacentBVertex(1);
			b2 = v1.getAdjacentBVertex(2);
			if(b2e == b1) {b1e = pinch? b2 : b1;}
			else if(b2e == b2) {b1e = pinch? b1 : b2;}
			else {
				b2e.name = b1.name = b2.name = 0;
				s.add(0, b2e);
				s.add(0, b1);
				if(b2e.pqTree.reductionCheck(s)) {
					b1.pqTree.addNeutral(v1);
					b2e.name = b1.name = b2.name = Node.bVertex;
					b1 = v1.getAdjacentBVertex(1);
					b2 = v1.getAdjacentBVertex(2);
					b1e = pinch? b2 : b1;
				} else if(b2e.pqTree.reductionCheck(s)) {
					s.remove(0);
					s.add(0, b2);
					b1.pqTree.addNeutral(v1);
					b2e.name = b1.name = b2.name = Node.bVertex;
					b1 = v1.getAdjacentBVertex(1);
					b2 = v1.getAdjacentBVertex(2);
					b1e = pinch? b1 : b2;
				} else {return false;}
				s.clear();
			}
		} else {return false;}
		
		if(qiList.get(0) == u2s)
			if(!pathExtend1(b2e, v2, qiList) || !pathExtend2(b1e, v1, piList)) {return false;}
		else if(piList.get(0) == u2s)
			if(!pathExtend1(b1e, v1, piList) || !pathExtend2(b2e, v2, qiList)) {return false;}
		else {return false;}
		
		if(pinch) {
			if(b2e == v2.getAdjacentBVertex(1)) {b2e = v2.getAdjacentBVertex(2);}
			else {b2e = v2.getAdjacentBVertex(1);}
		}
		if(b1e == b2e) {return true;}
		if(b1e.pqTree != b2e.pqTree) {return false;}
		b1e.name = 0;
		b2e.name = 0;
		s.add(b1e);
		s.add(b2e);
		if(!b1e.pqTree.reduction(s)) {return false;};
		b1e.name = Node.bVertex;
		b1e.pqTree.union(b1e);
		b2e.name = Node.bVertex;
		b2e.pqTree.union(b2e);
		return true;
	}
//--------------------------------------------------------------
	private NodeSet getStartNodeSet(PQ_tree v, ArrayList list) {
		int i;
		NodeSet Hh = new NodeSet(), bns = new NodeSet();
		PQ_tree uh, u;
		Node wkb, b, wkh;
		
		if(v.getHead(1).isPChild()) {
			bns.set(v.getAdjacentBVertex(1), v.getAdjacentBVertex(2));
			return bns;
		}
		Hh.set(v.getHead(1), v.getHead(2));
		uh = v;
		if(uh.uij.size() != 0) {
			if(!uh.reduction(Hh)) {return null;}
			b = uh.headFix().getAdjacentBVertex();
		} else {
			u = (PQ_tree)list.get(list.indexOf(uh)-1);
			Hh.set(uh.getHead(1), uh.getHead(2));
			if(u.dip == 1) {
				if(uh.reduction(u, Hh) == cannot) {return null;}
				b = uh.headFix(u).getAdjacentBVertex();
			} else {
				wkh = u.getHead(uh);
				if(!uh.reduction(Hh, wkh)) {return null;}
				b = uh.headFix(wkh.getAdjacentBVertex()).getAdjacentBVertex();
			}
		}
		bns.add(b);
		return bns;
	}
//--------------------------------------------------------------
	private void resetUnion(PQ_tree v, PQ_tree w) {
		int i, j;
		Node b, wkb;
		
		v.dip = 2;
		if(w.l != 0) for(i=1; i<=2; i++) for(j=1; j<=2; j++) 
			if(v.getAdjacentBVertex(i) == w.getAdjacentBVertex(j)) {
				v.dip = 1;
				wkb = v.getAdjacentBVertex(i);
				b = w.insertBVertex(j, v.getHead(i));
				//if(wkb == bi1s) {bi1s = b;}
				i = j = 3; // loop out
			}
		if(v.getAdjacentTree(1) == v.getAdjacentTree(2)) {v.dip = 1;}
	}
//--------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class PQ_tree {
	// for PQ_tree
	int blockCount;
	int blockedNodes;
	int offTheTop;
	Node[] leaf;
	Node root, pseudoNode, prunedRoot;
	Queue queuedNode = new Queue();
	Queue blockedNode = new Queue();
	Queue initializeNode = new Queue();
	Node[] endNode1 = new Node[2], endNode2 = new Node[2]; // (inS, notInS) S = full or bvertex
										// endNode1:if posible, endNode1[1] = null

	
	
	// for PQ_graph
	int l, d;
	int dp = 0, dip = 0; // d^+, d_i^+
	Node head1, head2;
	int inK = 0; // 0:defalt, 1:queued, 2:checked, 3:
	ArrayList uij = new ArrayList(); 
	int[] sigma, pi;
	boolean isTwoTerminal = false;
	int inSCount = 0;
	NodeSet consHS = new NodeSet();
	int consType = -1; // -1:default, 0:Non Graphic, 1:* Hd Hd *, 2:* Hd Hd,
	
	// debug
	//static int tCount = 0;
	//String treeName;
	//ArrayList allNode = new ArrayList();
//--------------------------------------------------------------
	public PQ_tree(int[] s, Node[] element){ // OK
		// 	
		leaf = new Node[s.length];
		root = new Node(Node.pNode, this);
		//allNode.add(root); // debug
		for(int i=0; i<s.length; i++){
			leaf[i] = new Node(s[i], this);
			//allNode.add(leaf[i]); // debug
			element[s[i]] = leaf[i];
			leaf[i].parent = root;
			if(i == 0) continue;
			leaf[i].add(leaf[i-1]);
		}
		root.childCount = s.length;
		l = 0;
		sigma = s;
		//treeName = "T" + (++tCount); // debug
	}
//--------------------------------------------------------------
	public PQ_tree(int[] s, int[] p, Node bv1, Node bv2, Node[] element){ // OK
		ArrayList al = new ArrayList();
		
		sigma = s;
		pi = p;
		leaf = new Node[s.length];
		root = new Node(Node.pNode, this);
		//allNode.add(root); // debug
		if(s.length > 0) {
			for(int i=0; i<s.length; i++){
				leaf[i] = new Node(s[i], this);
				//allNode.add(leaf[i]); // debug
				element[s[i]] = leaf[i];
				leaf[i].parent = root;
				if(i == 0) continue;
				leaf[i].add(leaf[i-1]);
			}
		}
		head1 = new Node(Node.head, this);
		//allNode.add(head1); // debug
		head1.setBVertex(bv1);
		head1.parent = root;
		if(s.length > 0) head1.add(leaf[0]);
		head2 = new Node(Node.head , this);
		//allNode.add(head2); // debug
		head2.setBVertex(bv2);
		head2.parent = root;
		head2.add(head1);
		root.childCount = s.length + 2;
		if(s.length > 0) {
			al.add(head1);
			al.add(head2);
			reduction(al);
		}
		l = (bv1.pqTree.l > bv2.pqTree.l) ? (bv1.pqTree.l + 1) : (bv2.pqTree.l + 1);
		bv1.headCount++;
		bv2.headCount++;
		//treeName = "T" + (++tCount); // debug
	}
//--------------------------------------------------------------
	public PQ_tree(PQ_tree v1, PQ_tree v2) { // OK
		Node b1, b2, b1s, b2s, q, p;
		b1 = v1.getAdjacentBVertex(1);
		b2 = v1.getAdjacentBVertex(2);
		b1s = new Node(Node.bVertex, this);
		//allNode.add(b1s); // debug
		b2s = new Node(Node.bVertex, this);
		//allNode.add(b2s); // debug
		head1 = new Node(Node.head, this);
		//allNode.add(head1); // debug
		head2 = new Node(Node.head, this);
		//allNode.add(head2); // debug
		q = new Node(Node.qNode, this);
		//allNode.add(q); // debug
		p = new Node(Node.pNode, this);
		//allNode.add(p); // debug
		
		root = q;
		q.endmostChildren.set(b1s, b2s);
		b1s.parent = q;
		b2s.parent = q;
		b1s.immediateSiblings.set(p);
		p.immediateSiblings.set(b1s, b2s);
		b2s.immediateSiblings.set(p);
		head1.parent = p;
		head2.parent = p;
		head1.add(head2);
		p.childCount = 2;
		
		v1.getHead(b1).setBVertex(b1s);
		v1.getHead(b2).setBVertex(b2s);
		v2.getHead(b1).setBVertex(b1s);
		v2.getHead(b2).setBVertex(b2s);
		head1.setBVertex(b1);
		head2.setBVertex(b2);
		b1.headCount--;
		b2.headCount--;
		
		dp = v1.dp;
		l = v1.l;
		isTwoTerminal = true;
		sigma = new int[0];
		pi = v1.pi;
		//treeName = "T" + (++tCount); // debug
	}
//--------------------------------------------------------------
	public void setPermutation(Node[] element) {
		int i, j;
		Node wkn, nx1, nx2, p, nq, nb1, nb2, en1, en2, prev, temp;
		Queue s = new Queue();
		
		//System.out.println(treeName);
		for(i=0; i<sigma.length; i++) {s.enQueue(element[sigma[i]]);}
		if(l != 0) {
			s.enQueue(head1);
			s.enQueue(head2);
		}
		
		while(s.size() > 0) {
			wkn = (Node)s.deQueue();//dispAll();System.out.println("wkn "+wkn.nodeName);
			if(wkn.isPChild()) {
				p = wkn.parent;
				if(p == null || p.childCount == 1) {continue;}
				nq = new Node(Node.qNode, this);
				//allNode.add(nq); // debug
				wkn.parent = nq;
				nx1 = wkn.next;
				nx1.remove();
				nx1.parent = nq;
				nq.endmostChildren.set(wkn, nx1);
				nx1.immediateSiblings.set(wkn);
				wkn.immediateSiblings.set(nx1);
				while(wkn.next != wkn) {
					nx1 = wkn.next;
					nx1.remove();
					nx1.insert(wkn, wkn.getTheOther(nx1));
				}
				p.childCount = 1;
				exchangeNode(p, nq);
				s.enQueue(wkn);
			} else {
				nx1 = wkn.immediateSiblings.get(0);
				nx2 = wkn.immediateSiblings.get(1);
				if(nx1 == null || nx2 == null)
					{p = wkn.parent;}
				else if(nx1.name == Node.bVertex && nx1.getTheOther(wkn) == null)
					{p = nx1.parent;}
				else if(nx2.name == Node.bVertex && nx2.getTheOther(wkn) == null)
					{p = nx2.parent;}
				else {continue;}
				if(p.isEndmost()) {
					nx1 = p.immediateSiblings.get(0);
					en1 = p.endmostChildren.get(0);
					en2 = p.endmostChildren.get(1);
					nx1.immediateSiblings.exchange(p, en1);
					en1.immediateSiblings.add(nx1);
					en2.parent = p.parent;
					p.parent.endmostChildren.exchange(p, en2);
					union(nx1);
				} else if(p.isMiddle()){
					nx1 = p.immediateSiblings.get(0);
					nx2 = p.immediateSiblings.get(1);
					en1 = p.endmostChildren.get(0);
					en2 = p.endmostChildren.get(1);
					nx1.immediateSiblings.exchange(p, en1);
					en1.immediateSiblings.add(nx1);
					nx2.immediateSiblings.exchange(p, en2);
					en2.immediateSiblings.add(nx2);
					union(nx1);
					union(nx2);
				} else {
					if(p.parent == null || p.parent.childCount == 1) {continue;}
					while(p.next != p) {
						nx1 = p.next;
						nx1.remove();
						nx1.insert(p.endmostChildren.get(0), null);
					}
					p.parent.childCount = 1;
					exchangeNode(p.parent, p);
				}
				s.enQueue(wkn);
			}
		}
		if(l != 0) {
			unionHead(head1);
			unionHead(head2);
		}
		//dispAll();
		
		s.clear();
		for(i=0; i<sigma.length; i++) {s.enQueue(element[sigma[i]]);}
		if(l != 0) {
			s.enQueue(head1);
			s.enQueue(head2);
		}

		while(s.size() > 0) {
			wkn = (Node)s.deQueue();
			for(j=0; j<2; j++) {
				nx1 = wkn.immediateSiblings.get(j);
				if(nx1 == null) {
					if(wkn.name > 0) {
						nb1 = new Node(Node.bVertex, this);
						//allNode.add(nb1); // debug
						nb1.insert(wkn, null);
					}
				} else if(nx1.name > 0 && wkn.name > 0) {
					nb1 = new Node(Node.bVertex, this);
					//allNode.add(nb1); // debug
					nb1.insert(wkn, nx1);
				}
			}
		}
		temp = (l == 0)? element[sigma[0]] : head1;
		prev = temp.immediateSiblings.get(0);
		while(temp != null) {
			wkn = temp;
			temp = temp.getTheOther(prev);
			prev = wkn;
		}
		root = prev.parent;
		//dispAll();
	}
//--------------------------------------------------------------
/*
	public void dispAll() { // debug
		int i;
		Node n;
		
		System.out.print(treeName + ":l=" + l + ", Root=" + root.nodeName + ", head1=");
		if(head1 == null) System.out.print("null");
		else System.out.print(head1.nodeName + "-->" + head1.getAdjacentBVertex().nodeName);		
		System.out.print(", head2=");
		if(head2 == null) System.out.print("null");
		else System.out.print(head2.nodeName + "-->" + head2.getAdjacentBVertex().nodeName);
		System.out.println("");
		for(i=0; i<allNode.size(); i++) {
			n = (Node)allNode.get(i);
			System.out.print("  ");
			n.dispAll();
		}
	}
*/
//--------------------------------------------------------------
	private void initialize() { // OK
		Node x;
		
		pseudoNode = null;
		queuedNode.clear();
		blockedNode.clear();
		while(initializeNode.size() > 0) {
			x = (Node)initializeNode.deQueue();
			x.fullChildren.clear();
			x.partialChildren.clear();
			x.pertinentChildCount = 0;
			x.pertinentLeafCount = 0;
			x.label = Node.empty;
			x.mark = Node.unmarked;
			x.endNode1 = new Node[2];
			x.endNode2 = new Node[2];
		}
	}
//--------------------------------------------------------------
	public boolean reduction(ArrayList s) { // OK
		int i;
		Node wkn;
		
		initialize();
		if(s.size() == 0) {return true;}
		if( !bubble(s) || !reduce(s) ) {return false;}
		if(prunedRoot.name == Node.qNode) {
			for(i=0; i<2; i++) {
				endNode1[i] = prunedRoot.endNode1[i];
				endNode2[i] = prunedRoot.endNode2[i];
			}
		} else if(!prunedRoot.isPChild()) {
			endNode1[0] = endNode2[0] = prunedRoot;
			endNode1[1] = prunedRoot.immediateSiblings.get(1);
			endNode2[1] = prunedRoot.immediateSiblings.get(0);
			if(endNode1[1] != null && endNode1[1].name == Node.bVertex) {
				wkn = endNode1[0];
				endNode1[0] = endNode1[1];
				endNode1[1] = endNode1[1].getTheOther(wkn);
			}
			if(endNode2[1] != null && endNode2[1].name == Node.bVertex) {
				wkn = endNode2[0];
				endNode2[0] = endNode2[1];
				endNode2[1] = endNode2[1].getTheOther(wkn);
			}
		} else {endNode1[0] = endNode2[0] = endNode1[1] = endNode2[1] = null;}
		return true;
	}
//--------------------------------------------------------------
	public boolean reductionCheck(ArrayList s) { // OK
		int i;
		boolean bln = true;
		
		initialize();
		if(s.size() == 0) {return true;}
		return bubble(s) && reduceCheck(s);
	}
//--------------------------------------------------------------
	private boolean bubble(ArrayList s){ // OK
		Node x, y, temp, prev, wk;
		int i, listSize;
		Queue bs = new Queue();
		Queue us = new Queue();
		
		blockCount = 0;
		blockedNodes = 0;
		offTheTop = 0;
		
		for(i=0; i<s.size(); i++) {
			queuedNode.enQueue(s.get(i));
			initializeNode.enQueue(s.get(i));
		}
		while(queuedNode.size() + blockCount + offTheTop > 1) {
			if(queuedNode.size() == 0) {return false;}
			x = (Node)queuedNode.deQueue();
			x.mark = Node.blocked;
			blockedNode.enQueue(x);
			bs.clear();
			us.clear();
			for(i=0; i<x.immediateSiblings.size(); i++){
				y = x.immediateSiblings.get(i);
				if(y.mark == Node.blocked) {bs.enQueue(y);}
				if(y.mark == Node.unblocked) {us.enQueue(y);}
				if(y.name == Node.bVertex && y.label != Node.checked) {
					queuedNode.enQueue(y);
					initializeNode.enQueue(y);
					y.label = Node.checked;
				}
			}
			if(us.size() > 0) {
				y = (Node)us.deQueue();
				x.parent = y.parent;
				x.mark = Node.unblocked;
			}
			else if(x.immediateSiblings.size() < 2) {
				x.mark = Node.unblocked;
			}
			
			if(x.mark == Node.unblocked) {
				y = x.parent;
				listSize = 0;
				if( bs.size() > 0) {
					for(i=0; i<x.immediateSiblings.size(); i++){
						temp = x.immediateSiblings.get(i);
						prev = x;
						while( temp.mark == Node.blocked ) {
							temp.mark = Node.unblocked;
							temp.parent = y;
							if(!temp.labelCheck(Node.checked))y.pertinentChildCount++;
							wk = temp;
							temp = temp.getTheOther(prev);
							prev = wk;
							listSize++;
						}
					}
				}
				if(y == null) {offTheTop = 1;}
				else {
					if(!x.labelCheck(Node.checked)) {
						y.pertinentChildCount++;
					}
					if(y.mark == Node.unmarked){
						queuedNode.enQueue(y);
						initializeNode.enQueue(y);
						y.mark = Node.queued;
					}
				}
				blockCount -= bs.size();
				blockedNodes -= listSize;
			}
			else {
				blockCount += 1 - bs.size();
				blockedNodes++;
			}
		} 
		
		if(blockCount == 1) {
			pseudoNode = new Node(Node.qNode, this);
			//allNode.add(pseudoNode); // debug
			initializeNode.enQueue(pseudoNode);
			while(blockedNode.size() > 0) {
				x = (Node)blockedNode.deQueue();
				if(x.mark == Node.blocked) {
					x.parent = pseudoNode;
					if(!x.labelCheck(Node.checked)) {
						pseudoNode.pertinentChildCount++;
					}
					if( (x.immediateSiblings.get(0).mark != Node.blocked) || 
					    (x.immediateSiblings.get(1).mark != Node.blocked) ) {
						pseudoNode.endmostChildren.add(x);
					}
				}
			}
		}
		return true;
	}
//--------------------------------------------------------------
	private boolean reduce(ArrayList s){
		int i;
		Node x,y;
		
		queuedNode.clear();
		for(i=0; i<s.size(); i++) {
			queuedNode.enQueue(s.get(i));
			((Node)s.get(i)).pertinentLeafCount = 1;
		}
		while(queuedNode.size() > 0) {
			x = (Node)queuedNode.deQueue();
			if(x.pertinentLeafCount < s.size()) {
				y=x.parent;
				y.pertinentLeafCount += x.pertinentLeafCount;
				y.pertinentChildCount--;
				if(y.pertinentChildCount == 0) {
					queuedNode.enQueue(y);
				}
				if(!templateL1(x) && !templateP1(x) && !templateP3(x) &&
				   !templateP5(x) && !templateQ1(x) && !templateQ2(x) ) {
				   return false;
				}
			}
			else {
				if(x.parent != null) {initializeNode.enQueue(x.parent);}
				if(!templateL1(x) && !templateP1(x) && !templateP2(x) &&
				   !templateP4(x) && !templateP6(x) && !templateQ1(x) &&
				   !templateQ2(x) && !templateQ3(x) )
					{return false;}
			}
		}
		return true;
	}
//--------------------------------------------------------------
	private boolean reduceCheck(ArrayList s){
		int i;
		Node x,y;

		queuedNode.clear();
		for(i=0; i<s.size(); i++) {
			queuedNode.enQueue(s.get(i));
			((Node)s.get(i)).pertinentLeafCount = 1;
		}
		while(queuedNode.size() > 0) {
			x = (Node)queuedNode.deQueue();
			if(x.pertinentLeafCount < s.size()) {
				y=x.parent;
				y.pertinentLeafCount += x.pertinentLeafCount;
				y.pertinentChildCount--;
				if(y.pertinentChildCount == 0) {queuedNode.enQueue(y);}
				if(!templateL1Check(x) && !templateP1Check(x) && !templateP3Check(x) &&
				   !templateP5Check(x) && !templateQ1Check(x) && !templateQ2Check(x) )
					{return false;}
			}	else {
				if(x.parent != null) {initializeNode.enQueue(x.parent);}
				if(!templateL1Pattern(x) && !templateP1Pattern(x) && !templateP2Pattern(x) &&
				   !templateP4Pattern(x) && !templateP6Pattern(x) && !templateQ1Pattern(x) &&
				   !templateQ2Pattern(x) && !templateQ3Pattern(x) )
					{return false;}
			}
		}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateL1(Node x){ // OK
		// pattern
		if(!templateL1Pattern(x)) {return false;}
		// replacement
		x.label = Node.full;
		x.parent.fullChildren.enQueue(x);
		prunedRoot = x;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP1(Node x){ // OK
		// pattern
		if(!templateP1Pattern(x)) {return false;}
		// replacement
		x.label = Node.full;
		if(x.parent != null) {x.parent.fullChildren.enQueue(x);}
		prunedRoot = x;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP2(Node x)	{ // OK
		Node zf;
		int fullChildrenSize;
		
		// pattern
		if(!templateP2Pattern(x)) {return false;}
		// replacement
		zf = new Node(Node.pNode, this);
		//allNode.add(zf); // debug
		zf.parent = x;
		fullChildrenSize = x.fullChildren.size();
		zf.add((Node)x.fullChildren.peep());
		moveFullChildren(x, zf);
		zf.childCount = fullChildrenSize;
		x.childCount -= fullChildrenSize-1;
		prunedRoot = zf;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP3(Node x){ // OK
		int numberEmpty, fullChildrenSize;
		Node ec, zp, zf, ze;
		
		// pattern
		if(!templateP3Pattern(x)) {return false;}
		// replacement
		ec = x.getEmptyChild();
		zp = new Node(Node.qNode, this);
		//allNode.add(zp); // debug
		zp.label = Node.partial;
		initializeNode.enQueue(zp);
		zp.parent = x.parent;
		zp.pertinentLeafCount = x.pertinentLeafCount;
		zp.parent.partialChildren.enQueue(zp);
		exchangeNode(x, zp);
		fullChildrenSize = x.fullChildren.size();
		if(fullChildrenSize == 1) {
			zf = (Node)x.fullChildren.peep();
			zf.remove();
		}	else {
			zf = new Node(Node.pNode,this);
			//allNode.add(zf); // debug
			zf.label = Node.full;
			initializeNode.enQueue(zf);
			moveFullChildren(x, zf);
			zf.childCount = fullChildrenSize;
		}
		zf.parent = zp;
		numberEmpty = x.childCount - fullChildrenSize;
		if(numberEmpty == 1) {ze = ec;}
		else {
			ze = x;
			ze.label = Node.empty;
			ze.childCount = numberEmpty;
		}
		ze.parent = zp;
		zp.endmostChildren.set(zf, ze);
		zf.immediateSiblings.set(ze);
		ze.immediateSiblings.set(zf);
		prunedRoot = zp;
		prunedRoot.endNode1[0] = zf;
		prunedRoot.endNode1[1] = null;
		prunedRoot.endNode2[0] = zf;
		prunedRoot.endNode2[1] = ze;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP4(Node x){
		Node y, fc, zf;
		int fullChildrenSize;
		// pattern
		if(!templateP4Pattern(x)) {return false;}
		// replacement
		y = (Node)x.partialChildren.peep();
		fc = y.endmostChildren.getNode(Node.full);
		y.pertinentLeafCount = x.pertinentLeafCount;
		fullChildrenSize = x.fullChildren.size();
		if(fullChildrenSize == 1) {
			zf = (Node)x.fullChildren.peep();
			zf.remove();
		}	else {
			zf = new Node(Node.pNode, this);
			//allNode.add(zf); // debug
			moveFullChildren(x, zf);
			zf.childCount = fullChildrenSize;
		}
		zf.parent = y;
		fc.immediateSiblings.add(zf);
		zf.immediateSiblings.set(fc);
		y.endmostChildren.exchange(fc, zf);
		x.childCount -= fullChildrenSize;
		if(x.childCount == 1) {exchangeNode(x, y);}
		prunedRoot = y;
		prunedRoot.endNode1[0] = zf;
		prunedRoot.endNode1[1] = null;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP5(Node x){
		int numberEmpty, fullChildrenSize;
		Node y, ec, fc, es, zf, ze;
		
		// pattern
		if(!templateP5Pattern(x)) {return false;}
		
		// replacement
		y = (Node)x.partialChildren.peep();
		prunedRoot = y;
		ec = y.endmostChildren.getNode(Node.empty);
		fc = y.endmostChildren.getNode(Node.full);
		es = x.getEmptyChild();
		y.parent = x.parent;
		y.pertinentLeafCount = x.pertinentLeafCount;
		y.label = Node.partial;
		y.parent.partialChildren.enQueue(y);
		y.remove();
		exchangeNode(x, y);
		fullChildrenSize = x.fullChildren.size();
		if(fullChildrenSize > 0) {
			if(fullChildrenSize == 1) {
				zf = (Node)x.fullChildren.deQueue();
				zf.remove();
			} else {
				zf = new Node(Node.pNode, this);
				//allNode.add(zf); // debug
				zf.label = Node.full;
				initializeNode.enQueue(zf);
				moveFullChildren(x, zf);
				zf.childCount = fullChildrenSize;
			}
			zf.parent = y;
			fc.immediateSiblings.add(zf);
			zf.immediateSiblings.set(fc);
			y.endmostChildren.exchange(fc, zf);
			prunedRoot.endNode1[0] = zf;
			prunedRoot.endNode1[1] = null;
		}
		numberEmpty = x.childCount - fullChildrenSize -1;
		if(numberEmpty > 0) {
			if(numberEmpty == 1) {
				ze = es;
			} else {
				ze = x;
				ze.label = Node.empty;
				ze.childCount = numberEmpty;
			}
			ze.parent = y;
			ec.immediateSiblings.add(ze);
			ze.immediateSiblings.set(ec);
			y.endmostChildren.exchange(ec, ze);
		}
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP6(Node x){
		Node y1, y2, fc1, fc2, ec2, zf;
		int fullChildrenSize;
		
		// pattern
		if(!templateP6Pattern(x)) {return false;}
		// replacement
		y1 = (Node)x.partialChildren.deQueue();
		y2 = (Node)x.partialChildren.peep();
		fc1 = y1.endmostChildren.getNode(Node.full);
		fc2 = y2.endmostChildren.getNode(Node.full);
		ec2 = y2.endmostChildren.getNode(Node.empty);
		y1.pertinentLeafCount = x.pertinentLeafCount;
		fullChildrenSize = x.fullChildren.size();
		if(fullChildrenSize == 0) {
			fc1.immediateSiblings.add(fc2);
			fc2.immediateSiblings.add(fc1);
			union(fc1, fc2);
		} else {
			if(fullChildrenSize == 1) {
				zf = (Node)x.fullChildren.peep();
				zf.remove();
			}	else {
				zf = new Node(Node.pNode, this);
				//allNode.add(zf); // debug
				moveFullChildren(x, zf);
				zf.childCount = fullChildrenSize;
			}
			fc1.immediateSiblings.add(zf);
			zf.immediateSiblings.set(fc1, fc2);
			fc2.immediateSiblings.add(zf);
		}
		ec2.parent = y1;
		y2.remove();
		y1.endmostChildren.exchange(fc1, ec2);
		x.childCount -= fullChildrenSize + 1;
		if(x.childCount == 1) {exchangeNode(x, y1);}
		prunedRoot = y1;
		prunedRoot.endNode1[0] = y2.endNode2[0];
		prunedRoot.endNode1[1] = y2.endNode2[1];
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateQ1(Node x){ // OK
		// pattern
		if(!templateQ1Pattern(x)) {return false;}
		// replacement
		x.label = Node.full;
		if(x.parent != null) {x.parent.fullChildren.enQueue(x);}
		prunedRoot = x;
		prunedRoot.endNode1[0] = x.endmostChildren.get(0);
		prunedRoot.endNode1[1] = null;
		prunedRoot.endNode2[0] = x.endmostChildren.get(1);
		prunedRoot.endNode2[1] = null;
		return true;
	}
//--------------------------------------------------------------
	private boolean templateQ2(Node x){
		int fullChildrenCount = 0;
		Node temp, prev, wk, y, fc, fs, ec, es;
		
		// pattern
		if(!templateQ2Pattern(x)) {return false;}
		
		//replacement
		x.label = Node.partial;
		if(x.parent != null) {x.parent.partialChildren.enQueue(x);}
		if(x.partialChildren.size() > 0) {
			y = (Node)x.partialChildren.peep();
			fc = y.endmostChildren.getNode(Node.full);
			if(y.immediateSiblings.exist(Node.full)) {
				fs = y.immediateSiblings.getNode(Node.full);
				fs.immediateSiblings.exchange(y, fc);
				fc.immediateSiblings.add(fs);
				union(fc, fs);
			} else {
				x.endmostChildren.exchange(y, fc);
				fc.parent = x;
				x.endNode1[0] = y.endNode1[0];
			}
			ec = y.endmostChildren.getNode(Node.empty);
			if(y.immediateSiblings.exist(Node.empty)) {
				es = y.immediateSiblings.getNode(Node.empty);
				es.immediateSiblings.exchange(y, ec);
				ec.immediateSiblings.add(es);
				union(ec, es);
			} else {
				x.endmostChildren.exchange(y, ec);
				ec.parent = x;
			}
			x.endNode2[0] = y.endNode2[0];
			x.endNode2[1] = y.endNode2[1];
		}
		prunedRoot = x;
		if(x.endmostChildren.get(0).labelCheck(Node.empty)) {
			prunedRoot.endNode1[0] = x.endmostChildren.get(1);
		} else {prunedRoot.endNode1[0] = x.endmostChildren.get(0);}
		prunedRoot.endNode1[1] = null;
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateQ3(Node x){
		int partinentCounter, partialChildrenSize;
		Node y, sy1, sy2, prev, wk, fc1, fc2, fc, fs, ec, es;
		
		// pattern
		if(!templateQ3Pattern(x)) {return false;}
		
		//replacement
		partialChildrenSize = x.partialChildren.size();
		if(partialChildrenSize > 0) {
			y = (Node)x.partialChildren.deQueue();
			x.endNode2[0] = y.endNode2[0];
			x.endNode2[1] = y.endNode2[1];
			if(y.immediateSiblings.exist(Node.partial)){
				fc1 = y.endmostChildren.getNode(Node.full);
				fc2 = ((Node)x.partialChildren.peep()).endmostChildren.getNode(Node.full);
				fc1.immediateSiblings.add(fc2);
				fc2.immediateSiblings.add(fc1);
				union(fc1, fc2);
			}
			fc = y.endmostChildren.getNode(Node.full);
			if(y.immediateSiblings.exist(Node.full)){
				fs = y.immediateSiblings.getNode(Node.full);
				fs.immediateSiblings.exchange(y, fc);
				fc.immediateSiblings.add(fs);
				union(fc, fs);
			}
			ec = y.endmostChildren.getNode(Node.empty);
			if(y.immediateSiblings.exist(Node.empty)) {
				es = y.immediateSiblings.getNode(Node.empty);
				es.immediateSiblings.exchange(y, ec);
				ec.immediateSiblings.add(es);
				union(ec, es);
			} else {
				x.endmostChildren.exchange(y, ec);
				ec.parent = x;
			}
			
			if(partialChildrenSize == 2) {
				y = (Node)x.partialChildren.deQueue();
				x.endNode1[0] = y.endNode2[0];
				x.endNode1[1] = y.endNode2[1];
				fc = y.endmostChildren.getNode(Node.full);
				if(y.immediateSiblings.exist(Node.full)){
					fs = y.immediateSiblings.getNode(Node.full);
					fs.immediateSiblings.exchange(y, fc);
					fc.immediateSiblings.add(fs);
					union(fc, fs);
				}
				ec = y.endmostChildren.getNode(Node.empty);
				if(y.immediateSiblings.exist(Node.empty)) {
					es = y.immediateSiblings.getNode(Node.empty);
					es.immediateSiblings.exchange(y, ec);
					ec.immediateSiblings.add(es);
					union(ec, es);
				} else {
					x.endmostChildren.exchange(y, ec);
					ec.parent = x;
				}
			}
		}
		prunedRoot = x;
		return true;
	}
//--------------------------------------------------------------
	private boolean templateL1Check(Node x){ // OK
		// pattern
		if(!templateL1Pattern(x)) {return false;}
		
		// replacement
		x.label = Node.full;
		x.parent.fullChildren.enQueue(x);
		return true;
	}
//--------------------------------------------------------------
	private boolean templateP1Check(Node x){
		// pattern
		if(!templateP1Pattern(x)) {return false;}
		// replacement
		x.label = Node.full;
		if(x.parent != null) {x.parent.fullChildren.enQueue(x);}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateP3Check(Node x){ // OK
		// pattern
		if(!templateP3Pattern(x)) {return false;}
		// replacement
		x.label = Node.partial;
		x.parent.partialChildren.enQueue(x);
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateP5Check(Node x){ // OK
		// pattern
		if(!templateP5Pattern(x)) {return false;}
		
		// replacement
		x.label = Node.partial;
		x.parent.partialChildren.enQueue(x);
		return true;	
	}
//--------------------------------------------------------------
	private boolean templateQ1Check(Node x){
		// pattern
		if(!templateQ1Pattern(x)) {return false;}
		
		// replacement
		x.label = Node.full;
		if(x.parent != null) {x.parent.fullChildren.enQueue(x);}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateQ2Check(Node x){
		// pattern
		if(!templateQ2Pattern(x)) {return false;}
		
		//replacement
		x.label = Node.partial;
		if(x.parent != null) {x.parent.partialChildren.enQueue(x);}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateL1Pattern(Node x) // OK
		{return (x.name != Node.pNode) && (x.name != Node.qNode);}
//--------------------------------------------------------------
	private boolean templateP1Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.childCount == x.fullChildren.size());}
//--------------------------------------------------------------
	private boolean templateP2Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.partialChildren.size() == 0);}
//--------------------------------------------------------------
	private boolean templateP3Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.partialChildren.size() == 0);}
//--------------------------------------------------------------
	private boolean templateP4Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.partialChildren.size() == 1);}
//--------------------------------------------------------------
	private boolean templateP5Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.partialChildren.size() == 1);}
//--------------------------------------------------------------
	private boolean templateP6Pattern(Node x) // OK
		{return (x.name == Node.pNode) && (x.partialChildren.size() == 2);}
//--------------------------------------------------------------
	private boolean templateQ1Pattern(Node x){
		int i;
		Node temp, prev, wk;
		
		if(x.name != Node.qNode) {return false;}
		if(x == pseudoNode) {return false;}
		if(x.partialChildren.size() > 0) {return false;}
		if(!x.endmostChildren.get(0).labelCheck(Node.valid)) {return false;}
		if(!x.endmostChildren.get(1).labelCheck(Node.valid)) {return false;}
		prev = x.endmostChildren.get(0);
		temp = prev.immediateSiblings.get(0);
		while(temp != x.endmostChildren.get(1)){
			if(!temp.labelCheck(Node.valid)) {return false;}
			wk = temp;
			temp = temp.getTheOther(prev);
			prev = wk;
		}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateQ2Pattern(Node x){
		int i, fullChildrenCount = 0;
		Node temp, prev, wk, y, fc, fs, ec, es;
		if(x.name != Node.qNode) {return false;}
		if(x == pseudoNode) {return false;}
		if(x.partialChildren.size() > 1) {return false;}
		while(true){
			if(x.endmostChildren.get(0).labelCheck(Node.valid)){
				prev = x.endmostChildren.get(0);
				temp = prev.immediateSiblings.get(0);
				if(x.fullChildren.size() > 0) {
					if(prev.labelCheck(Node.full) || temp.labelCheck(Node.full)) {break;}
				} else {
					if(prev.labelCheck(Node.partial) || prev.labelCheck(Node.checked)) {break;}
				}			
			}
			if(x.endmostChildren.get(1).labelCheck(Node.valid)) {
				prev = x.endmostChildren.get(1);
				temp = prev.immediateSiblings.get(0);
				if(x.fullChildren.size() > 0) {
					if(prev.labelCheck(Node.full) || temp.labelCheck(Node.full)) {break;}
				} else {
					if(prev.labelCheck(Node.partial) || prev.labelCheck(Node.checked)) {break;}
				}
			}
			return false;
		}
		if(prev.labelCheck(Node.full)) {fullChildrenCount++;}
		else {prev.label = Node.full;}
		x.endNode1[0] = prev;
		x.endNode1[1] = null;
		while(temp.labelCheck(Node.valid)){
			if(temp.labelCheck(Node.full)) {fullChildrenCount++;}
			else {temp.label = Node.full;}
			wk = temp;
			temp = temp.getTheOther(prev);
			prev = wk;
		}
		x.endNode2[0] = prev;
		x.endNode2[1] = temp;
		if(x.fullChildren.size() != fullChildrenCount) {return false;}
		if((x.partialChildren.size() > 0) && (!temp.labelCheck(Node.partial))) {return false;}
		else if(temp.getTheOther(prev) != null) {temp.getTheOther(prev).label = Node.empty;}
		return true;
	}
//--------------------------------------------------------------
	private boolean templateQ3Pattern(Node x){
		int i, partinentCounter, partialChildrenSize;
		Node y, sy1, sy2, prev, wk, fc1, fc2, fc, fs, ec, es;
		
		if(x.name != Node.qNode) {return false;}
		if(x.partialChildren.size() > 2) {return false;}
		if(x.fullChildren.size() > 0) {
			y = (Node)x.fullChildren.peep();
			partinentCounter = 1;
			sy1 = y.immediateSiblings.get(0);
			prev = y;
			while(sy1.labelCheck(Node.valid)) {
				if(sy1.labelCheck(Node.full)) {partinentCounter++;}
				else {sy1.label = Node.full;}
				wk = sy1;
				sy1 = sy1.getTheOther(prev);
				prev = wk;
				if(sy1 == null) {return false;}
			}
			if(sy1.labelCheck(Node.partial)) {
				if(sy1.getTheOther(prev) != null) {sy1.getTheOther(prev).label = Node.empty;}
				
				partinentCounter++;
			} else {
				x.endNode1[0] = prev;
				x.endNode1[1] = sy1;
			}
			sy2 = y.immediateSiblings.get(1);
			if(sy2 == null) {return false;}
			prev = y;
			while(sy2.labelCheck(Node.valid)) {
				if(sy2.labelCheck(Node.full)){partinentCounter++;}
				else {sy2.label = Node.full;}
				wk = sy2;
				sy2 = sy2.getTheOther(prev);
				prev = wk;
				if(sy2 == null) {return false;}
			}
			if(sy2.labelCheck(Node.partial)) {
				if(sy2.getTheOther(prev) != null) {sy2.getTheOther(prev).label = Node.empty;}
				partinentCounter++;
			} else {
				if(x.endNode1[0] == null) {
					x.endNode1[0] = prev;
					x.endNode1[1] = sy2;
				} else {
					x.endNode2[0] = prev;
					x.endNode2[1] = sy2;
				}
			}
			if(partinentCounter != 
			   x.fullChildren.size() + x.partialChildren.size() )
				{return false;}
		} else {
			sy1 = (Node)x.partialChildren.deQueue();
			sy2 = (Node)x.partialChildren.deQueue();
			x.partialChildren.enQueue(sy1);
			x.partialChildren.enQueue(sy2);
			if(sy1.immediateSiblings.exist(Node.partial)) {
				if(sy1.getTheOther(sy2) != null) {sy1.getTheOther(sy2).label = Node.empty;}
				if(sy2.getTheOther(sy1) != null) {sy2.getTheOther(sy1).label = Node.empty;}
				return true;
			}
			y = sy1.immediateSiblings.get(0);
			if(y != null && y.name == Node.bVertex && 
			   y.getTheOther(sy1) != null && y.getTheOther(sy1).labelCheck(Node.partial)) {
				y.label = Node.full;
				if(sy1.getTheOther(y) != null) {sy1.getTheOther(y).label = Node.empty;}
				if(sy2.getTheOther(y) != null) {sy2.getTheOther(y).label = Node.empty;}
				x.fullChildren.enQueue(y);
				return true;
			}
			y = sy1.immediateSiblings.get(1);
			if(y != null && y.name == Node.bVertex && 
			   y.getTheOther(sy1) != null && y.getTheOther(sy1).labelCheck(Node.partial)) {
				y.label = Node.full;
				if(sy1.getTheOther(y) != null) {sy1.getTheOther(y).label = Node.empty;}
				if(sy2.getTheOther(y) != null) {sy2.getTheOther(y).label = Node.empty;}
				x.fullChildren.enQueue(y);
				return true;
			}
			return false;
		}
		return true;
	}
//--------------------------------------------------------------
	private void moveFullChildren(Node from, Node to) { // OK
		Node w, prev;
		
		w = (Node)from.fullChildren.deQueue();
		w.remove();
		w.parent = to;
		while(from.fullChildren.size() > 0){
			prev = w;
			w = (Node)from.fullChildren.deQueue();
			w.remove();
			w.add(prev);
			w.parent = to;
		}
	}
//--------------------------------------------------------------
	private void exchangeNode(Node from, Node to) { // OK
		int i;
		Node w;
		
		if(from.isPChild()) {
			to.add(from);
			from.remove();
			if(from.parent != null) {to.parent = from.parent;}
		} else if(from.isEndmost()) {
			from.parent.endmostChildren.exchange(from, to);
			to.parent = from.parent;
			w = from.immediateSiblings.get(0);
			w.immediateSiblings.exchange(from, to);
			to.immediateSiblings.set(w);
		} else {
			to.immediateSiblings.clear();
			for(i=0; i<2; i++) {
				w = from.immediateSiblings.get(i);
				w.immediateSiblings.exchange(from, to);
				to.immediateSiblings.add(w);
			}
		}
	}
//--------------------------------------------------------------
	public PQ_tree getAdjacentTree(int n) { // OK
		return getAdjacentBVertex(n).pqTree;
	}
//--------------------------------------------------------------
	public Node getAdjacentBVertex(int n) { // OK
		if(n == 1) {return head1.getAdjacentBVertex();} 
		else if(n == 2) {return head2.getAdjacentBVertex();}
		else {
			System.out.println("Error at getAdjacentBVertex");
			return null;
		}
	}
//--------------------------------------------------------------
	public Node getAdjacentBVertex(PQ_tree v) { // OK
		int i;
		Node b;
		
		for(i=1; i<=2; i++) {
			b = getAdjacentBVertex(i);
			if(b.pqTree == v) {return b;}
		}
		return null;
	}
//--------------------------------------------------------------
	public Node getHead(int n) { // OK
		if(n == 1) {return head1;}
		else if(n == 2) {return head2;}
		else {
			System.out.println("Error at getHead");
			return null;
		}
	}
//--------------------------------------------------------------
	public Node getHead(Node bv) { // OK
		
		if(head1.getAdjacentBVertex() == bv) {return head1;}
		else if(head2.getAdjacentBVertex() == bv) {return head2;}
		else {return null;}
	}
//--------------------------------------------------------------
	public Node getHead(PQ_tree t) { // OK
		
		if(getAdjacentTree(1) == t) {return head1;}
		else if(getAdjacentTree(2) == t) {return head2;}
		else {return null;}
	}
//--------------------------------------------------------------
	public boolean reduction(PQ_graph g) { // OK

		Node wkn, b;
		if(!reduction(uij)) {return false;}
		if(prunedRoot.name != Node.qNode
		   || (prunedRoot.endNode1[1] == null && prunedRoot.endNode2[1] == null)) {
			if(prunedRoot.isMiddle() && 
			   prunedRoot.immediateSiblings.get(0).isEndmost() && 
			   prunedRoot.immediateSiblings.get(0).name == Node.bVertex &&
			   prunedRoot.immediateSiblings.get(1).isEndmost() && 
			   prunedRoot.immediateSiblings.get(1).name == Node.bVertex) {
				g.bi1s = prunedRoot.immediateSiblings.get(0);
				g.bi2s = prunedRoot.immediateSiblings.get(1);
				return true;
			}
			wkn = new Node(Node.qNode, this);
			//allNode.add(wkn); // debug
			g.bi1s = new Node(Node.bVertex, this);
			//allNode.add(g.bi1s); // debug
			g.bi2s = new Node(Node.bVertex, this);
			//allNode.add(g.bi2s); // debug
			exchangeNode(prunedRoot, wkn);
			g.bi1s.parent = wkn;
			g.bi2s.parent = wkn;
			wkn.endmostChildren.set(g.bi1s, g.bi2s);
			g.bi1s.immediateSiblings.set(prunedRoot);
			prunedRoot.immediateSiblings.set(g.bi1s, g.bi2s);
			g.bi2s.immediateSiblings.set(prunedRoot);
		} else {
			if(endNode1[0].name == Node.bVertex) {g.bi1s = endNode1[0];}
			else {
				g.bi1s = new Node(Node.bVertex, this);
				//allNode.add(g.bi1s); // debug
				g.bi1s.insert(endNode1[0], endNode1[1]);
			}
			if(endNode2[0].name == Node.bVertex) {g.bi2s = endNode2[0];}
			else {
				g.bi2s = new Node(Node.bVertex, this);
				//allNode.add(g.bi2s); // debug
				g.bi2s.insert(endNode2[0], endNode2[1]);
			}
		}
		return true;
	}
//--------------------------------------------------------------
	public boolean reduction(NodeSet Hh, Node h) {

		Node b;
		boolean bln;
		
		b = h.getAdjacentBVertex();
		b.name = 0;
		if(uij.size() == 0) {
			uij.add(b);
			uij.add(Hh.get(0));
			if(Hh.size() == 2) {uij.add(Hh.get(1));}
			bln = reduction(uij);
			uij.clear();
		}
		else {bln = reduction(uij) && subReduction(Hh) 
		            && subReduction(b) && subReduction(Hh, b);}
		b.name = Node.bVertex;
		union(b);
		return bln;
	}
//--------------------------------------------------------------
	public boolean reduction(Node h) { // OK

		Node b;
		boolean bln;
		
		b = h.getAdjacentBVertex();
		b.name = 0;
		bln = reduction(uij) && subReduction(b);
		b.name = Node.bVertex;
		union(b);
		return bln;
	}
//--------------------------------------------------------------
	public boolean reduction(NodeSet Hh) { // OK

		return reduction(uij) && subReduction(Hh);
	}
//--------------------------------------------------------------
	public boolean reduction(Node h, Node n2) {

		Node n1;
		boolean bln;
		
		n1 = h.getAdjacentBVertex();
		if(n1 == n2) {return false;}
		n1.name = 0;
		if(n2.name == Node.bVertex) {n2.name = 0;}
		if(uij.size() == 0) {
			uij.add(n1);
			uij.add(n2);
			bln = reduction(uij);
			uij.clear();
		} else {bln = reduction(uij) && subReduction(n1) 
		              && subReduction(n2) && subReduction(n1, n2);}
		n1.name = Node.bVertex;
		union(n1);
		if(n2.name == 0) {
			n2.name = Node.bVertex;
			union(n2);
		}
		return bln;
	}
//--------------------------------------------------------------
	public int reduction(PQ_tree t) {

		Node b1, b2, p, c, nb1, nb2, nq, en1, en2;
		boolean bln1 = false, bln2 = false;
		
		if(!reductionCheck(uij)) {return PQ_graph.cannot;}
		b1 = t.getAdjacentBVertex(1);
		b2 = t.getAdjacentBVertex(2);
		
		b1.name = b2.name = 0;
		if(reductionCheck(uij)) {
			uij.add(0, b1);
			uij.add(0, b2);
			if(reductionCheck(uij)) {
				uij.remove(0);
				uij.remove(0);
				b1.name = b2.name = Node.bVertex;
				return PQ_graph.both;
			}
			uij.remove(0);
			uij.remove(0);
		}
		b1.name = b2.name = Node.bVertex;

		b1.name = 0;
		bln1 = reductionCheck(uij) && subReductionCheck(b1);
		b1.name = Node.bVertex;
		
		b2.name = 0;
		bln2 = reductionCheck(uij) && subReductionCheck(b2);
		b2.name = Node.bVertex;
		
		if(bln1 && bln2) {
			addNeutral(t);
			return PQ_graph.either;
		} else if(bln1) {
			b1.name = 0;
			if(!subReduction(b1)) {return PQ_graph.cannot;}
			b1.name = Node.bVertex;
			union(b1);
			return PQ_graph.b1only;
		} else if(bln2){
			b2.name = 0;
			if(!subReduction(b2)) {return PQ_graph.cannot;}
			b2.name = Node.bVertex;
			union(b2);
			return PQ_graph.b2only;
		}
		return PQ_graph.cannot;
	}
//--------------------------------------------------------------
	public boolean reductionCheckBoth(PQ_tree t) {

		Node b1, b2;
		boolean bln;
		
		if(!reductionCheck(uij)) {return false;}
		b1 = t.getAdjacentBVertex(1);
		b2 = t.getAdjacentBVertex(2);
		b1.name = b2.name = 0;
		if(!reductionCheck(uij)) {
			b1.name = b2.name = Node.bVertex;
			return false;
		}
		uij.add(0, b1);
		uij.add(0, b2);
		bln = reductionCheck(uij);
		uij.remove(0);
		uij.remove(0);
		b1.name = b2.name = Node.bVertex;
		return bln;
	}
//--------------------------------------------------------------
	public int reduction(PQ_tree t, NodeSet Hh) {

		Node b1, b2;
		boolean bln1 = false, bln2 = false;
		
		if(uij.size() != 0 && (!reduction(uij) || !subReduction(Hh))) 
			{return PQ_graph.cannot;}
		
		b1 = t.getAdjacentBVertex(1);
		b2 = t.getAdjacentBVertex(2);

		b1.name = 0;
		if(uij.size() != 0) {
			bln1 = reductionCheck(uij) && subReductionCheck(b1) 
			       && subReductionCheck(Hh) && subReductionCheck(Hh, b1);
		} else {
			uij.add(b1);
			bln1 = subReductionCheck(Hh);
			uij.clear();
		}
		b1.name = Node.bVertex;
		
		b2.name = 0;
		if(uij.size() != 0) {
			bln2 = reductionCheck(uij) && subReductionCheck(b2) 
			       && subReductionCheck(Hh) && subReductionCheck(Hh, b2);
		} else {
			uij.add(b2);
			bln2 = subReductionCheck(Hh);
			uij.clear();
		}
		b2.name = Node.bVertex;
		
		if(bln1 && bln2) {
			b1.name = 0;
			uij.add(0, b1);
			subReductionCheck(Hh);
			uij.remove(0);
			b1.name = Node.bVertex;
			addNeutral(t);
			return PQ_graph.either;
		} else if(bln1) {
			b1.name = 0;
			if(uij.size() != 0) {
				reduction(uij);
				subReduction(Hh);
				subReduction(b1);
			} else {
				uij.add(b1);
				subReduction(Hh);
				uij.clear();
			}
			b1.name = Node.bVertex;
			union(b1);
			return PQ_graph.b1only;
		} else if(bln2){
			b2.name = 0;
			if(uij.size() != 0) {
				reduction(uij);
				subReduction(Hh);
				subReduction(b2);
			} else {
				uij.add(b2);
				subReduction(Hh);
				uij.clear();
			}
			b2.name = Node.bVertex;
			union(b2);
			return PQ_graph.b2only;
		}
		return PQ_graph.cannot;
	}
//--------------------------------------------------------------
	public int reduction(PQ_tree t, Node b) {

		Node b1, b2;
		boolean bln1 = false, bln2 = false;
		
		if(t.getAdjacentBVertex(1) == b) {
			if(reduction(t.getHead(2), b)) {return PQ_graph.b2only;}
			else {return PQ_graph.cannot;}
		}
		if(t.getAdjacentBVertex(2) == b) {
			if(reduction(t.getHead(1), b)){return PQ_graph.b1only;}
			else {return PQ_graph.cannot;}
		}
		
		b.name = 0;
		
		if(uij.size() == 0 && (!reduction(uij) || !subReduction(b))) 
			{return PQ_graph.cannot;}
		
		b1 = t.getAdjacentBVertex(1);
		b2 = t.getAdjacentBVertex(2);
		
		b1.name = 0;
		if(uij.size() != 0) {
			bln1 = reductionCheck(uij) && subReductionCheck(b1) 
			       && subReductionCheck(b) && subReductionCheck(b1, b);
		} else {
			uij.add(b1);
			uij.add(b);
			bln1 = reductionCheck(uij);
			uij.clear();
		}
		b1.name = Node.bVertex;
		
		b2.name = 0;
		if(uij.size() != 0) {
			bln2 = reductionCheck(uij) && subReductionCheck(b2) 
			       && subReductionCheck(b) && subReductionCheck(b2, b);
		} else {
			uij.add(b2);
			uij.add(b);
			bln2 = reductionCheck(uij);
			uij.clear();
		}
		b2.name = Node.bVertex;
		
		if(bln1 && bln2) {
			b1.name = 0;
			uij.add(0, b1);
			subReductionCheck(b);
			uij.remove(0);
			b1.name = Node.bVertex;
			addNeutral(t);
			b.name = Node.bVertex;
			union(b);
			return PQ_graph.either;
		}	else if(bln1) {
			b1.name = 0;
			if(uij.size() != 0) {
				reduction(uij);
				subReduction(b);
				subReduction(b1);
			} else {
				uij.add(b1);
				uij.add(b);
				reduction(uij);
				uij.clear();
			}
			b1.name = Node.bVertex;
			union(b1);
			b.name = Node.bVertex;
			union(b);
			return PQ_graph.b1only;
		} else if(bln2) {
			b2.name = 0;
			if(uij.size() != 0) {
				reduction(uij);
				subReduction(b);
				subReduction(b2);
			} else {
				uij.add(b2);
				uij.add(b);
				reduction(uij);
				uij.clear();
			}
			b2.name = Node.bVertex;
			union(b2);
			b.name = Node.bVertex;
			union(b);
			return PQ_graph.b2only;
		}
		return PQ_graph.cannot;
	}
//--------------------------------------------------------------
	public Node getStartNode(PQ_tree v1, NodeSet bs1, PQ_tree v2, NodeSet bs2) {

		int i, j;
		boolean bln;
		Node b1, b2, wkb1, wkb2, h1, h2;
		ArrayList s = new ArrayList();
		
		for(i=0; i<bs1.size(); i++) for(j=0; j<bs2.size(); j++) {
			b1 = bs1.get(i);
			b2 = bs2.get(j);
			h1 = v1.getHead(b1);
			h2 = v2.getHead(b2);
			if(b1.pqTree != this || b2.pqTree != this) {continue;}
			b1.name = b2.name = 0;
			s.add(b1);
			s.add(b2);
			bln = reductionCheck(s);
			b1.name = b2.name = Node.bVertex;
			s.clear();
			if(bln) {
				if(v1.dip == 1) {
					b2.name = 0;
					uij.add(0, b2);
					wkb1 = v1.getAdjacentBVertex(1);
					wkb2 = v1.getAdjacentBVertex(2);
					wkb1.name = wkb2.name = 0;
					if(subReductionCheck(wkb1) && subReductionCheck(wkb2)) {
						addNeutral(v1);
					}
					wkb1.name = wkb2.name = Node.bVertex;
					uij.remove(0);
					b2.name = Node.bVertex;
				}
				if(v2.dip == 1) {
					b1 = h1.getAdjacentBVertex();
					b1.name = 0;
					uij.add(0, b1);
					wkb1 = v2.getAdjacentBVertex(1);
					wkb2 = v2.getAdjacentBVertex(2);
					wkb1.name = wkb2.name = 0;
					if(subReductionCheck(wkb1) && subReductionCheck(wkb2)) {
						addNeutral(v2);
					}
					wkb1.name = wkb2.name = Node.bVertex;
					uij.remove(0);
					b1.name = Node.bVertex;
				}
				b1 = h1.getAdjacentBVertex();
				b2 = h2.getAdjacentBVertex();
				b1.name = b2.name = 0;
				s.add(b1);
				s.add(b2);
				reduction(s);
				b1.name = Node.bVertex;
				union(b1);
				b2.name = Node.bVertex;
				union(b2);
				return b2;
			}
		}
		return null;
	}
//--------------------------------------------------------------
	private boolean subReduction(Node b) { // OK

		boolean bln;
		uij.add(0, b);
		bln = reduction(uij);
		uij.remove(0);
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReduction(Node b1, Node b2) { // OK

		boolean bln;
		uij.add(0, b1);
		uij.add(0, b2);
		bln = reduction(uij);
		uij.remove(0);
		uij.remove(0);
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReduction(NodeSet Hh) { // OK

		boolean bln;
		uij.add(0, Hh.get(0));
		if(Hh.size() == 2) {uij.add(0, Hh.get(1));}
		bln = reduction(uij);
		uij.remove(0);
		if(Hh.size() == 2) {uij.remove(0);}
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReduction(NodeSet Hh, Node b) { // OK

		boolean bln;
		uij.add(0, b);
		uij.add(0, Hh.get(0));
		if(Hh.size() == 2) {uij.add(0, Hh.get(1));}
		bln = reduction(uij);
		uij.remove(0);
		uij.remove(0);
		if(Hh.size() == 2) {uij.remove(0);}
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReductionCheck(Node b) { // OK

		boolean bln;
		uij.add(0, b);
		bln = reductionCheck(uij);
		uij.remove(0);
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReductionCheck(Node b1, Node b2) { // OK

		boolean bln;
		uij.add(0, b1);
		uij.add(0, b2);
		bln = reductionCheck(uij);
		uij.remove(0);
		uij.remove(0);
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReductionCheck(NodeSet Hh) { // OK

		boolean bln ;
		uij.add(0, Hh.get(0));
		if(Hh.size() == 2) {uij.add(0, Hh.get(1));}
		bln = reductionCheck(uij);
		uij.remove(0);
		if(Hh.size() == 2) {uij.remove(0);}
		return bln;
	}
//--------------------------------------------------------------
	private boolean subReductionCheck(NodeSet Hh, Node b) { // OK

		boolean bln ;
		uij.add(0, b);
		uij.add(0, Hh.get(0));
		if(Hh.size() == 2) {uij.add(0, Hh.get(1));}
		bln = reductionCheck(uij);
		uij.remove(0);
		uij.remove(0);
		if(Hh.size() == 2) {uij.remove(0);}
		return bln;
	}
//--------------------------------------------------------------
	public Node insertEndnode(Node b){

		Node n = null, en;
		int i;
		b.name = 0;
		reduction(uij);
		if(b == endNode1[1]) {
			if(endNode2[0].name == Node.bVertex) {n = endNode2[0];}
			else {
				n = new Node(Node.bVertex, this);
				//allNode.add(n); // debug
				n.insert(endNode2[0], endNode2[1]);
			}
		} else if(b == endNode2[1]) {
			if(endNode1[0].name == Node.bVertex) {n = endNode1[0];}
			else {
				n = new Node(Node.bVertex, this);
				//allNode.add(n); // debug
				n.insert(endNode1[0], endNode1[1]);
			}
		} else {
			subReduction(b);
			if(b == endNode1[0]) {
				if(endNode2[0].name == Node.bVertex) {n = endNode2[0];}
				else {
					n = new Node(Node.bVertex, this);
					//allNode.add(n); // debug
					n.insert(endNode2[0], endNode2[1]);
				}
			} else if(b == endNode2[0]) {
				if(endNode1[0].name == Node.bVertex) {n = endNode1[0];}
				else {
					n = new Node(Node.bVertex, this);
					//allNode.add(n); // debug
					n.insert(endNode1[0], endNode1[1]);
				}
			}
			else {return null;}
		}
		b.name = Node.bVertex;
		union(b);
		
		for(i=0; i<n.immediateSiblings.size(); i++) {
			en = n.immediateSiblings.get(i);
			if(en != null && en.name == Node.head) {
				n = en.getAdjacentBVertex();
				break;
			}
		}
		return n;
	}
//--------------------------------------------------------------
	public Node insertEndnode(NodeSet Hh){

		Node n = null, h1, h2, p = null, wkn, pp;
		
		h1 = Hh.get(0);
		h2 = (Hh.size() == 1)? Hh.get(0) : Hh.get(1);
		reduction(uij);
		if(h1 == endNode1[1] || h2 == endNode1[1]) {
			if(endNode2[0].name == Node.bVertex) {n = endNode2[0];}
			else {
				n = new Node(Node.bVertex, this);
				//allNode.add(n); // debug
				n.insert(endNode2[0], endNode2[1]);
			}
		} else if(h1 == endNode2[1] || h2 == endNode2[1]) {
			if(endNode1[0].name == Node.bVertex) {n = endNode1[0];}
			else {
				n = new Node(Node.bVertex, this);
				//allNode.add(n); // debug
				n.insert(endNode1[0], endNode1[1]);
			}
		} else {
			subReduction(Hh);
			if(h1 == endNode1[0] || h2 == endNode1[0]) {
				if(endNode2[0].name == Node.bVertex) {n = endNode2[0];}
				else {
					n = new Node(Node.bVertex, this);
				//allNode.add(n); // debug
					n.insert(endNode2[0], endNode2[1]);	
				}
			} else if(h1 == endNode2[0] || h2 == endNode2[0]) {
				if(endNode1[0].name == Node.bVertex) {n = endNode1[0];}
				else {
					n = new Node(Node.bVertex, this);
					//allNode.add(n); // debug
					n.insert(endNode1[0], endNode1[1]);
				}
			} 
			else {return null;}
		}
		return n;
	}
//--------------------------------------------------------------
	public Node headFix() {

		Node h = null;
		
		if(subReductionCheck(head1)) {h = head1;}
		else if(subReductionCheck(head2)) {h = head2;}
		else {System.out.println("Error at headFix");}
		subReduction(h);
		return h;
	}
//--------------------------------------------------------------
	public Node headFix(Node b) {

		Node h = null;
		ArrayList s = new ArrayList();
		
		b.name = 0;
		s.add(b);
		s.add(0, head1);
		if(reductionCheck(s)) {h = head1;}
		s.remove(0); // remove h1
		s.add(0, head2);
		if(reductionCheck(s)) {h = head2;}
		s.remove(0); // remove h1
		s.add(h);
		if(h != null) {reduction(s);}
		b.name = Node.bVertex;
		return h;
	}
//--------------------------------------------------------------
	public Node headFix(PQ_tree t) {

		int i, j;
		Node b, h;
		boolean bln;
		ArrayList s = new ArrayList();
		
		for(i=1; i<=2; i++) for(j=1; j<=2; j++) {
			b = t.getAdjacentBVertex(i);
			if(b.pqTree != this) {continue;}
			h = this.getHead(j);
			b.name = 0;
			s.add(b);
			s.add(h);
			bln = reductionCheck(s);
			s.clear();
			b.name = Node.bVertex;
			if(bln) {return h;}
		}
		return null;
	}
//--------------------------------------------------------------
	public Node insertBVertex(int i, Node h){

		Node h1, h2, n1, bv, b;
		
		if(i == 1) {
			h1 = head1;
			h2 = head2;
		} else {
			h1 = head2;
			h2 = head1;
		}
		n1 = h1.getTheOther(h2);
		if(n1 != null && n1.name == Node.bVertex) {bv = n1;}
		else {
			bv = new Node(Node.bVertex, this);
			//allNode.add(bv); // debug
			//if(h1.isPChild()) System.out.println("Error at insertBVertex397"); // debug
			bv.insert(h1, n1);
		}
		b = h.getAdjacentBVertex();
		b.moveTo(bv);
		getHead(i).setBVertex(b);
		
		return bv;
	}
//--------------------------------------------------------------
	private Node union(Node n1, Node n2) { // OK
		
		if(n1.name == Node.bVertex && n2.name == Node.bVertex) {
			n1.union(n2);
			n2.removeBVertex();
			return n1;
		}
		return null;
	}
//--------------------------------------------------------------
	public void unionHead(Node n1, Node n2) {
		
		if(n1.name == Node.head && n2.name == Node.bVertex) {
			n1.getAdjacentBVertex().union(n2);
			n2.removeBVertex();
		} else if(n1.name == Node.bVertex && n2.name == Node.head) {
			n2.getAdjacentBVertex().union(n1);
			n1.removeBVertex();
		}
	}
//--------------------------------------------------------------
	public void union(Node n) { // OK

		Node wkn1, wkn2;
		
		wkn1 = n.immediateSiblings.get(0);
		wkn2 = n.immediateSiblings.get(1);
		union(n, wkn1);
		if(wkn2 != null) {union(n, wkn2);}
	}
//--------------------------------------------------------------
	public void unionHead(Node n) { // OK

		Node wkn1, wkn2;
		
		wkn1 = n.immediateSiblings.get(0);
		wkn2 = n.immediateSiblings.get(1);
		if(wkn1 != null) {unionHead(n, wkn1);}
		if(wkn2 != null) {unionHead(n, wkn2);}
	}
//--------------------------------------------------------------
	public Node getNearestHead(Node b) {

		Node temp1, temp2, prev1, prev2, wkn;
		prev1 = prev2 = b;
		boolean loop1, loop2;
		temp1 = b.immediateSiblings.get(0);
		temp2 = b.immediateSiblings.get(1);
		
		while(temp1 != null || temp2 != null) {
			if(temp1 != null) {
				if(temp1.name == Node.head) {return temp1;}
				wkn = temp1;
				temp1 = temp1.getTheOther(prev1);
				prev1 = wkn;
			}
			if(temp2 != null) {
				if(temp2.name == Node.head) {return temp2;}
				wkn = temp2;
				temp2 = temp2.getTheOther(prev2);
				prev2 = wkn;
			}
		}
		return null;
	}
//--------------------------------------------------------------
	public void addNeutral(PQ_tree t) { //System.out.println("addNeutral");
		Node b1, b2, p, c, nb1, nb2, nq;
		
		b1 = t.getAdjacentBVertex(1);
		b2 = t.getAdjacentBVertex(2);
		if(b1.isEndmost() && b2.isEndmost() && 
		   b1.immediateSiblings.get(0) == b2.immediateSiblings.get(0) &&
		   !isTwoTerminal && b1.headCount > 1) {
			p = b1.parent;
			c = b1.immediateSiblings.get(0);
			nq = new Node(Node.qNode, this);
			//allNode.add(nq); // debug
			nb1 = new Node(Node.bVertex, this);
			//allNode.add(nb1); // debug
			nb2 = new Node(Node.bVertex, this);
			//allNode.add(nb2); // debug
			b1.immediateSiblings.exchange(c, nq);
			b2.immediateSiblings.exchange(c, nq);
			nq.immediateSiblings.set(b1, b2);
			nq.endmostChildren.set(nb1, nb2);
			nb1.immediateSiblings.set(c);
			nb2.immediateSiblings.set(c);
			nb1.parent = nq;
			nb2.parent = nq;
			c.immediateSiblings.set(nb1, nb2);
			
			if(p.labelCheck(Node.empty)) {//System.out.println("in");
				t.head1.setBVertex(nb1);
				t.head2.setBVertex(nb2);
				b1.headCount--;
				b2.headCount--;
				nb1.headCount = nb2.headCount = 1;
			} else {//System.out.println("out");
				b1.moveTo(nb1);
				b2.moveTo(nb2);
				nb1.headCount = b1.headCount - 1;
				nb2.headCount = b2.headCount - 1;
				t.head1.setBVertex(b1);
				t.head2.setBVertex(b2);
				b1.headCount = b2.headCount = 1;
			}
		}
	}
//--------------------------------------------------------------
	public void setConsecutiveHead() {
		
		if(l == 0) {return;}
		if(uij.size() != 0) {
			uij.add(0, head1); // head1, other
			uij.add(0, head2); // head2, head1, other
			if(!reductionCheck(uij)) {
				uij.remove(0); // head1, other
				uij.remove(0); // other
				consType = 0;
			}	else {
				consType = 1;
				uij.remove(0); // head1, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head1);
				}
				uij.remove(0); // other
				uij.add(0, head2); // head2, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head2);
				}
				uij.remove(0); // other
			}
		
		}
	}
//--------------------------------------------------------------
	public void setConsecutiveHead(Node b) {
		
		if(l == 0) {return;}
		if(uij.size() != 0) {
			uij.add(0, head1); // head1, other
			uij.add(0, head2); // head2, head1, other
			if(!reductionCheck(uij)) {
				consType = 0;
				uij.remove(0); // head1, other
				uij.remove(0); // other
			} else {
				consType = 1;
				uij.remove(0); // head1, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head1);
				}
				uij.remove(0); // other
				uij.add(0, head2); // head2, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head2);
				}
				uij.remove(0); // other
			}
		} else {
			consType = 0;
			b.name = 0;
			uij.add(b); // b
			uij.add(0, head1); // head1, b
			if(reductionCheck(uij)) {
				consType = 2;
				consHS.add(head1);
			}
			uij.remove(0); // b
			uij.add(0, head2); // head2, b
			if(reductionCheck(uij)) {
				consType = 2;
				consHS.add(head2);
			}
			uij.clear(); // empty
			b.name = Node.bVertex;
		}
	}
//--------------------------------------------------------------
	public void setConsecutiveHead(PQ_tree t) {

		Node b1, b2;
		
		if(l == 0) {return;}
		if(uij.size() != 0) {
			uij.add(0, head1); // head1, other
			uij.add(0, head2); // head2, head1, other
			if(!reductionCheck(uij)) {
				consType = 0;
				uij.remove(0); // head1, other
				uij.remove(0); // other
			}	else {
				consType = 1;
				uij.remove(0); // head1, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head1);
				}
				uij.remove(0); // other
				uij.add(0, head2); // head2, other
				if(reductionCheck(uij)) {
					consType = 2;
					consHS.add(head2);
				}
				uij.remove(0); // other
			}
		} else {
			b1 = t.getAdjacentBVertex(1);
			b2 = t.getAdjacentBVertex(2);
			setConsecutiveHead(b1);
			if(consType == 0) {setConsecutiveHead(b2);}
		}
	}
//--------------------------------------------------------------
	public boolean checkConsecutive(Node b) {
		// b *
		if(uij.size() == 0) {return false;}
		b.name = 0;
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			return false;
		}
		uij.add(0, b); // b, other
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0); // other
			return false;
		}
		uij.remove(0); // other
		b.name = Node.bVertex;
		return true;
	}
//--------------------------------------------------------------
	public boolean checkExactConsecutive(Node b) {
		if(uij.size() == 0) {return false;}
		b.name = 0;
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			return false;
		}
		uij.add(0, b); // b, other
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0); // other
			return false;
		}
		uij.remove(0); // other
		uij.add(0, head1); // head1, other
		uij.add(0, head2); // head2, head1, other
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0); // head1, other
			uij.remove(0); // other
			return false;
		}
		uij.add(0, b);
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0);
			uij.remove(0); // head1, other
			uij.remove(0); // other
			return false;
		}
		b.name = Node.bVertex;
		uij.remove(0);
		uij.remove(0); // head1, other
		uij.remove(0); // other
		return true;
	}
//--------------------------------------------------------------
	public boolean checkHeadConsecutive(Node b) {
		if(uij.size() == 0) {return false;}
		b.name = 0;
		uij.add(0, head1); // head1, other
		uij.add(0, head2); // head2, head1, other
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0); // head1, other
			uij.remove(0); // other
			return false;
		}
		uij.add(0, b); // b, head2, head1, other
		if(!reductionCheck(uij)) {
			b.name = Node.bVertex;
			uij.remove(0);
			uij.remove(0);
			uij.remove(0);
			return false;
		}
		b.name = Node.bVertex;
		uij.remove(0);
		uij.remove(0);
		uij.remove(0);
		return true;
	}
//--------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class Graph {
	EdgeForGraph[] edgeA;
	int[] wkA;
	int edgeSize, columnSize, rowSize;
//--------------------------------------------------------------------
	public Graph(ArrayList graphList, int cSize, int rSize) {
		int i;
		columnSize = cSize;
		rowSize = rSize;
		edgeSize = columnSize + rowSize;
		edgeA = new EdgeForGraph[edgeSize+1];
		for(i=0; i<graphList.size(); i++) {
			wkA = (int[])graphList.get(i);
			edgeA[wkA[0]] = new EdgeForGraph(wkA[1], wkA[2]);
		}
	}
//--------------------------------------------------------------------
	boolean testMatrix(Stack rowS) {
		int[] wkA;
		int[] degree = new int[edgeSize*2];
		int[] incidentEdge = new int[edgeSize*2];
		int i,j,vertexCounter, edgeCounter;
		
		vertexCounter = 0;
		edgeCounter = 0;
		for(i=1; i<=columnSize; i++) {
			if(edgeA[i] == null) continue;
			edgeCounter++;
			if(incidentEdge[edgeA[i].end[0]] == 0) {
				incidentEdge[edgeA[i].end[0]] = i;
				vertexCounter++;
			} else 
				EdgeForGraph.union(edgeA[incidentEdge[edgeA[i].end[0]]], edgeA[i]);
			if(incidentEdge[edgeA[i].end[1]] == 0) {
				incidentEdge[edgeA[i].end[1]] = i;
				vertexCounter++;
			} else 
				EdgeForGraph.union(edgeA[incidentEdge[edgeA[i].end[1]]], edgeA[i]);
		}
		for(i=2; i<=columnSize; i++) {
			if(edgeA[i] == null) continue;
			if(EdgeForGraph.find(edgeA[1]) != EdgeForGraph.find(edgeA[i])) return false;
		}
		if(vertexCounter != edgeCounter + 1) return false;
		while(!rowS.empty()) {
			vertexCounter = 0;
			wkA = (int[])rowS.pop();
			for(i=0; i<wkA.length; i++) {
				degree[edgeA[wkA[i]].end[0]]++;
				degree[edgeA[wkA[i]].end[1]]++;
			}
			for(i=0; i<degree.length; i++) {
				if(degree[i] != 2 && degree[i] != 0) return false;
				else if(degree[i] == 2) degree[i] = 0;
			}
		}
		return true;
	}
//--------------------------------------------------------------------
}
//////////////////////////////////////////////////////////////////////
class EdgeForGraph {
	int[] end = new int[2];
	int size;
	EdgeForGraph parent;
//--------------------------------------------------------------------
	public EdgeForGraph(int e1, int e2) {
		end[0] = e1;
		end[1] = e2;
		size = 0;
		parent = this;
	}
//--------------------------------------------------------------------
	static void union(EdgeForGraph i, EdgeForGraph j) {
		EdgeForGraph e1, e2;
		e1 = find(i);
		e2 = find(j);
		if(e1.size > e2.size) {
			e2.parent = e1;
			e1.size += e2.size;
		}
		else {
			e1.parent = e2;
			e2.size += e1.size;
		}
	}
//--------------------------------------------------------------------
	static EdgeForGraph find(EdgeForGraph e) {
		EdgeForGraph wk, j, root;
		wk = e;
		while(wk.parent != wk) {
			wk = wk.parent;
		}
		root = wk;
		wk = e;
		while(wk != root) {
			j = wk.parent;
			wk.parent = root;
			wk = j;
		}
		
		return root;
	}
//--------------------------------------------------------------------
}
//////////////////////////////////////////////////////////////////////
class Node {
	// PQ_tree
	int childCount = 0;
	Node next, prev;
	Queue fullChildren = new Queue();
	Queue partialChildren = new Queue();
	Node parent = null;
	NodeSet endmostChildren = new NodeSet();
	NodeSet immediateSiblings = new NodeSet();
	int pertinentChildCount = 0;
	int pertinentLeafCount = 0;
	byte label = 0;
		static final byte empty = 0, 
		                  full = 1, 
		                  partial = 2, 
		                  checked = 3, // checked means bVertex not in rq
		                  valid = 4; // full or checked
	int mark = 0;
		static final int unmarked = 0, queued = 1, blocked = 2, unblocked = 3;
	int name = 0;
		static final int pNode = -1,
		                 qNode = -2,
		                 head = -3,
		                 bVertex = -4;
		                 // positive : leaf name, 0 : temp leaf
	Node[] endNode1 = new Node[2], endNode2 = new Node[2]; // (inS, notInS) S = full or bvertex
										// endNode1:if posible, endNode1[1] = null
	
	// PQ_graph
	PQ_tree pqTree;
	UFNode ufnode;
	boolean inS = false;
	int headCount = 0;
	int nodeNameForGraph = 0;
	
	// debug
	//static int hCount = 0, bCount = 0, pCount=0, qCount=0;
	//String nodeName;
//--------------------------------------------------------------
	Node(int name, PQ_tree tree){ // OK

		this.name = name;
		next = this;
		prev = this;
		pqTree = tree;
		if(name == bVertex)	{ufnode = new UFNode(this);}
		
		/*
		if(name > 0) nodeName = "" + name; // debug
		else if(name == pNode) nodeName = "P" + (++pCount); // debug
		else if(name == qNode) nodeName = "Q" + (++qCount); // debug
		else if(name == head) nodeName = "H" + (++hCount); // debug
		else if(name == bVertex) nodeName = "B" + (++bCount); // debug
		else System.out.println("Error at PQ_tree"); // debug
		*/
	}
//--------------------------------------------------------------
/*
	public void dispAll() { // debug
		System.out.print(nodeName + ":CdCt=" + childCount + ", Prt=");
		if(parent == null && immediateSiblings.size() == 0) System.out.print("Root");
		else if(immediateSiblings.size() > 1) System.out.print("null");
		else System.out.print(parent.nodeName);
		System.out.print(", ImSb=(");
		if(immediateSiblings.get(0) == null) System.out.print("null");
		else System.out.print(immediateSiblings.get(0).nodeName);
		System.out.print(", ");
		if(immediateSiblings.get(1) == null) System.out.print("null");
		else System.out.print(immediateSiblings.get(1).nodeName);
		System.out.print("), EmCd=(");
		if(endmostChildren.get(0) == null) System.out.print("null");
		else System.out.print(endmostChildren.get(0).nodeName);
		System.out.print(", ");
		if(endmostChildren.get(1) == null) System.out.print("null");
		else System.out.print(endmostChildren.get(1).nodeName);
		System.out.println(")");
	}
*/
//--------------------------------------------------------------
	public void add(Node x) { // OK
		this.next = x.next;
		this.prev = x;
		x.next.prev = this;
		x.next = this;
	}
//--------------------------------------------------------------
	public void remove() { // OK
		this.prev.next = this.next;
		this.next.prev = this.prev;
		this.next = this;
		this.prev = this;
	}
//--------------------------------------------------------------
	public Node getEmptyChild() {
		int i;
		Node wk;
		if(fullChildren.size() > 0) {wk = (Node)fullChildren.peep();}
		else if(partialChildren.size() > 0) {
			wk = (Node)partialChildren.peep();
		} else {return null;}
		for(i=0; i<childCount; i++) {
			if(wk.label == empty) {return wk;}
			wk = wk.next;
		}
		return null;
	}
//--------------------------------------------------------------
	public boolean labelCheck(int lbl) { // OK
		if(lbl != valid) {return label == lbl;}
		else {return (label == full || label == checked);}
	}
//--------------------------------------------------------------
	public void setBVertex(Node bv) // head.setBVertex(bv) OK
		{ufnode = bv.ufnode;}
//--------------------------------------------------------------
	public Node getAdjacentBVertex() // head.getAdjacentBVertex() 
		{return ufnode.find().getBVertex();}
//--------------------------------------------------------------
	public PQ_tree getAdjacentTree() // head.getAdjacentTree() 
		{return ufnode.find().getBVertex().pqTree;}
//--------------------------------------------------------------
	public void insert(Node n1, Node n2) {
		if(n2 == null) {insert(n1);}
		else if(n1 == null) {insert(n2);}
		else {
			n1.immediateSiblings.exchange(n2, this);
			this.immediateSiblings.set(n1, n2);
			n2.immediateSiblings.exchange(n1, this);
		}
	}
//--------------------------------------------------------------
	public void insert(Node n) { // OK
		n.parent.endmostChildren.exchange(n, this);
		this.parent = n.parent;
		n.immediateSiblings.add(this);
		this.immediateSiblings.set(n);
	}
//--------------------------------------------------------------
	public void removeBVertex() { // OK

		Node wkn1, wkn2;
		
		//if(this.isPChild()) System.out.println("Error at removeBVertex025"); // debug 
		if(this.isEndmost()) {
			wkn1 = this.immediateSiblings.get(0);
			this.parent.endmostChildren.exchange(this, wkn1);
			wkn1.immediateSiblings.remove(this);
			wkn1.parent = this.parent;
		} else {
			wkn1 = this.immediateSiblings.get(0);
			wkn2 = this.immediateSiblings.get(1);
			wkn1.immediateSiblings.exchange(this, wkn2);
			wkn2.immediateSiblings.exchange(this, wkn1);
		}
	}
//--------------------------------------------------------------
	public void moveTo(Node tgt) { // OK

		UFNode ufn1, ufn2;
		ufn1 = this.ufnode;
		ufn2 = tgt.ufnode;
		this.ufnode = ufn2;
		tgt.ufnode = ufn1;
		ufn1.bVertex = tgt;
		ufn2.bVertex = this;
	}
//--------------------------------------------------------------
	public void union(Node bv) { // OK
		//union this with bv, delete bv
		UFNode wkufn;
		
		wkufn = ufnode.union(bv.ufnode);
		this.ufnode = wkufn;
		wkufn.bVertex = this;
	}
//--------------------------------------------------------------
	public boolean isPChild(){ // OK

		return this.immediateSiblings.size() == 0;
	}
//--------------------------------------------------------------
	public boolean isEndmost(){ // OK

		return this.immediateSiblings.size() == 1;
	}
//--------------------------------------------------------------
	public boolean isMiddle(){ // OK

		return this.immediateSiblings.size() == 2;
	}
//--------------------------------------------------------------
	public Node getTheOther(Node n) {
		if(n == null) {
			return this.immediateSiblings.get(0);
		}
		return this.immediateSiblings.getTheOther(n);
	}
//--------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class NodeSet {
	private Node[] nodeSet = new Node[2];
	private int nodeSetSize;
//--------------------------------------------------------------
	public NodeSet(){ // OK
		nodeSet[0] = null;
		nodeSet[1] = null;
		nodeSetSize = 0;
	}
//--------------------------------------------------------------
	public void clear() { // OK
		nodeSet[0] = null;
		nodeSet[1] = null;
		nodeSetSize = 0;	
	}
//--------------------------------------------------------------
	public int size(){return nodeSetSize;} // OK
//--------------------------------------------------------------
	public boolean exist(int label) {
		if(label != Node.valid){
			if((nodeSet[0] != null) && (nodeSet[0].label == label)) {return true;}
			if((nodeSet[1] != null) && (nodeSet[1].label == label)) {return true;}
		} else {
			if((nodeSet[0] != null) && (nodeSet[0].label == Node.full || nodeSet[0].label == Node.checked)) {
				return true;
			}
			if((nodeSet[1] != null) && (nodeSet[1].label == Node.full || nodeSet[1].label == Node.checked)) {
				return true;
			}
		}
		return false;
	}
//--------------------------------------------------------------
	public void set(Node n) { // OK
		nodeSet[0] = n;
		nodeSet[1] = null;
		nodeSetSize = 1;
	}
//--------------------------------------------------------------
	public void set(Node n, Node m) { // OK
		nodeSet[0] = n;
		nodeSet[1] = m;
		nodeSetSize = 2;
	}
//--------------------------------------------------------------
	public void add(Node n) { // OK
		if(nodeSet[0] == null) {nodeSet[0] = n;}
		else {nodeSet[1] = n;}
		nodeSetSize++; 
	}
//--------------------------------------------------------------
	public void remove(Node n) { // OK
		if(nodeSet[1] == n) {nodeSet[1] = null;}
		else {
			nodeSet[0] = nodeSet[1];
			nodeSet[1] = null;
		}
		nodeSetSize--;
	}
//--------------------------------------------------------------
	public void exchange(Node from, Node to) { // OK
		remove(from);
		add(to);
	}
//--------------------------------------------------------------
	public Node get(int i){return nodeSet[i];} // OK
//--------------------------------------------------------------
	public Node getNode(byte label) {
		if(label != Node.valid){
			if((nodeSet[0] != null) && (nodeSet[0].label == label)) {return nodeSet[0];}
			if((nodeSet[1] != null) && (nodeSet[1].label == label)) {return nodeSet[1];}
		} else {
			if((nodeSet[0] != null) && (nodeSet[0].label == Node.full || nodeSet[0].label == Node.checked)) {
				return nodeSet[0];
			}
			if((nodeSet[1] != null) && (nodeSet[1].label == Node.full || nodeSet[1].label == Node.checked)) {
				return nodeSet[1];
			}
		}
		return null;
	}
//--------------------------------------------------------------
	private int getIndex(Node x) {return (nodeSet[0] == x)? 0 : 1;} // OK
//--------------------------------------------------------------
	public Node getTheOther(Node n) {return get(1-getIndex(n));} // OK
//--------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class UFNode { // OK
	Node bVertex;
	UFNode parent;
	int size;
//--------------------------------------------------------------
	public UFNode(Node bv) { // OK

		bVertex = bv;
		size = 1;
		parent = null;
	}
//--------------------------------------------------------------
	public UFNode union(UFNode ufn) { // OK
		// return root UFNode
		UFNode ufn1, ufn2;
		ufn1 = this.find();
		ufn2 = ufn.find();
		if(ufn1.size > ufn2.size) {
			ufn2.parent = ufn1;
			ufn1.size += ufn2.size;
			return ufn1;
		} else {
			ufn1.parent = ufn2;
			ufn2.size += ufn1.size;
			return ufn2;
		}
	}
//--------------------------------------------------------------
	public UFNode find() { // OK
		// return root
		UFNode wk, wkp, root;
		
		wk = this;
		while(wk.parent != null) {wk = wk.parent;}
		root = wk;
		wk = this;
		while(wk != root) {
			wkp = wk.parent;
			wk.parent = root;
			wk = wkp;
		}
		return root;
	}
//--------------------------------------------------------------
	public Node getBVertex(){return bVertex;} // OK
//--------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class Link {
	public Object data;
	public Link next;
// -------------------------------------------------------------
	public Link(Object d){ data = d; }
// -------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
class Queue{
	private Link first;
	private Link last;
	private int size;
// -------------------------------------------------------------
	public Queue(){
		first = null;
		last = null;
		size = 0;
	}
// -------------------------------------------------------------
	public boolean isEmpty(){return size == 0;}
// -------------------------------------------------------------
	public Object peep(){return first.data;}
// -------------------------------------------------------------
	public void enQueue(Object data){
		Link newLink = new Link(data);
		if( isEmpty() )
			first = newLink;
		else
			last.next = newLink;
		last = newLink;
		size++;
	}
// -------------------------------------------------------------
	public Object deQueue(){
		Object temp = first.data;
		if(first.next == null)         // if only one item
			last = null;                // null <-- last
		first = first.next;            // first --> old next
		size--;
		return temp;
	}
// -------------------------------------------------------------
	public int size() { return size; }
// -------------------------------------------------------------
	public void clear() {
		first = null;
		last = null;
		size = 0;	
	}
// -------------------------------------------------------------
}
////////////////////////////////////////////////////////////////
  






