import Jama.*;
import java.util.Arrays;
public class MyUtil{
    public static double array_sum(double[] a){
	double ret=0;
	for(int i=0;i<a.length;i++)
	    ret += a[i];
	return ret;
    }
    public static int array_sum(int[] a){
	int ret=0;
	for(int i=0;i<a.length;i++)
	    ret += a[i];
	return ret;
    }
    public static int[] array_intersect(int[] a,int[] b){
	if(a.length != b.length){
	    return new int[0];
	}
	int[] ret = new int[a.length];
	for(int i=0;i<a.length;i++)
	    if(a[i] != 0 && b[i] !=0)
		ret[i] = 1;
	return ret;	
    }

    public static int[] array_union(int[] a,int[] b){
	if(a.length != b.length){
	    return new int[0];
	}
	int[] ret = new int[a.length];
	for(int i=0;i<a.length;i++)
	    if(a[i] != 0 || b[i] !=0)
		ret[i] = 1;
	return ret;	
    }
        
    public static int[] asort(double[] list){
	int n = list.length;
	int[] ret = new int[n];
	double[] sorted = (double[])list.clone();
	boolean[] used  = new boolean[n];
	Arrays.sort(sorted);
	for(int i=0;i<n;i++){
	    for(int j=0;j<n;j++){
		if(sorted[i] ==  list[j] && !used[j]){
		    ret[i] = j;
		    used[j] = true;
		    break;
		} 
	    }
	}
	for(int i=0;i<n;i++)
	    list[i] = sorted[i];
	return ret;
    }
    public static void reverse(double[] list){
	double[] ret = new double[list.length];
	for(int i=0;i<list.length;i++)
	    ret[list.length-i-1] = list[i];
	for(int i=0;i<list.length;i++)
	    list[i] = ret[i];

    }    
    public static void reverse(int[] list){
	int[] ret = new int[list.length];
	for(int i=0;i<list.length;i++)
	    ret[list.length-i-1] = list[i];
	//list = ret.clone();
	for(int i=0;i<list.length;i++)
	    list[i] = ret[i];

    }
    
    public static double e_norm_2(Matrix semidefinite,Matrix vector){
	Matrix transvector = vector.transpose();
	Matrix ret;
	ret = transvector.times(semidefinite);
	ret = ret.times(vector);
	return ret.get(0,0);
    }

    public static Matrix make_first_ellipsoid(Submodular sub){
	int n = sub.getSize();
	Matrix ret = new Matrix(n,n);
	int[] subset = new int[n];
	for(int i=0;i<n;i++){
	    subset[i] = 1;
	    ret.set(i,i,n/Math.pow(sub.getValue(subset),2));
	    subset[i] = 0;
	}
	return ret;
    }
    public static boolean next_combination(int[] a){
	int j=0;
	boolean f=false;
	for(int i=a.length-1;i>=0;i--){
	    if(f && a[i] == 1){
		a[i+1] = 1;
		a[i] = 0;
		for(int k=i+2;k<a.length;k++){
		    if(k<=i+j+1)
			a[k] = 1;
		    else
			a[k] = 0;
		}
		return true;
	    }else if(a[i] == 1){
		j++;
	    }else{
		f=true;
	    }	    
	}
	return false;
    }

    public static boolean all_combination(int[] a){
	int elem_num=0;
	if(next_combination(a))
	    return true;
	for(int i=0;i<a.length;i++){
	    if(a[i] == 1)
		elem_num++;
	}
	if(elem_num == a.length)
	    return false;

	for(int i=0;i<a.length;i++)
	    if(i<elem_num+1)
		a[i] = 1;
	    else
		a[i] = 0;
	return true;
    }

       
    public static Matrix ellipsoid_expand(Matrix mat,Matrix vec){
	Matrix ret;
	int n = vec.getRowDimension();
	Matrix tmp_mat;
	double l = e_norm_2(mat,vec);
	ret = mat.times(  n*(l-1) / ( l*(n-1) )  );
	//ret.print(5,5);
	
	tmp_mat = mat.times(vec);
	tmp_mat = tmp_mat.times(vec.transpose());
	tmp_mat = tmp_mat.times(mat);

	ret = ret.plus(tmp_mat.times(
		 n/(l*l) * (1.0 - (l-1)/(n-1)*1.0 )
	      ));
	return ret;
    }

    public static Matrix ellipsoid_allign(Matrix mat){
	int n = mat.getRowDimension();
	Matrix ret = new Matrix(n,n);
	int[] getdiag = new int[n]; 
	for(int i=0;i<n;i++)
	    getdiag[i] = i;
	Matrix mat_inv = mat.inverse();
	for(int i=0;i<n;i++)
	    ret.set(i,i,mat_inv.get(i,i));	
	return ret.inverse();
    }

    public static void main(String[] args){
	/**
	int[] a = {1,0,0,1,0,0,1};
	int[] b = {0,0,1,1,1,0,0};
	double[][]  vec_data = {{1},{3}};
	double[][] mat_data = {{2,1},{1,4}};
	Matrix vec = new Matrix(vec_data);
	Matrix mat = new Matrix(mat_data);
	Matrix ans;
	
	//[0,0,0,1,0,0,0]
	System.out.println(Arrays.toString(array_intersect(a,b)));

	//[1,0,1,1,1,0,1]
	System.out.println(Arrays.toString(array_union(a,b)));

	//44
	System.out.println(e_norm_2(mat,vec));

	//[7/4  0  ]
	//[ 0   7/2]
	ans = ellipsoid_allign(mat);
	ans.print(2,2);
	

	int[] c_test = {1,1,1,0,0,0};
	while(next_combination(c_test))
	    System.out.println(Arrays.toString(c_test));
	**/
	int[] a_test = {1,0,0,0,0,0,0};
	do{
	    System.out.println(Arrays.toString(a_test));
	}while(all_combination(a_test));
	/**
	double[][] semidef = {{2,0},{0,1}};
	double[][] z = {{3},{2}};
	Matrix vec = new Matrix(z);
	Matrix mat = new Matrix(semidef);
	Matrix ans = ellipsoid_expand(mat,vec);
	ans.print(5,5);
	**/
	/*double[] vec = {1.2157400378416674, 1.2157400378416676, 1.2157400378416676, 1.2157400378416678, 1.2157400378416687,
 1.2157400378416745, 1.2157400378416752, 1.2157400378416787, 1.2157400378416803, 1.257289389846358,
1.2576895203393927, 1.2579623338049264, 1.2586499147615076, 1.2700724994583272, 1.2704969299328177,
			1.270669533175339, 1.2733707821217677, 5.582867378569215, 17.90255001773233, 21.398218335267963};
	*/
	double vec[] = {1,5,4,6,8,3,9,0};
     	System.out.println(Arrays.toString(asort(vec)));
	//reverse(vec);
	System.out.println(Arrays.toString(vec));

    } 

    
}