import Jama.*;
import java.util.*;
public class EllipsoidalApprox{
    /** instance type */
    static final int TYPE = 6;

    public static void main(String args[]){
      for(int l=5;l<10;l++){ //dimension
	for(int m=0;m<10;m++){    //repeat 10 times
	    long start, stop, diff;
	    start = System.currentTimeMillis();
	    
	    int n = l;
	    int j = 0;
	    double prevnorm=0;
	    int loopnum = 0;
            Submodular submo;
            switch (TYPE) {
	            default: submo = new GraphicMatroid(n); break;
	            case  1: submo = new MaxSubmodular(n);  break;
	            case  2: submo = new Kcover(n);         break;
	            case  3: submo = new Sqrt(n);           break;
	            case  4: submo = new Log(n);            break;
			    case  5: submo = new Logdet(n);         break;
	            case  6: submo = new Entropy(n);        break;
            }
	    SubmodularAnswer fhat = new SubmodularAnswer(n);
	    Matrix D = new Matrix(n,n);
	    Matrix B = new Matrix(n,n);
	    D = MyUtil.make_first_ellipsoid(submo);
	    double[][] z_data = new double[n][1];
	    double[] tmp = new double[n];
	    tmp = submo.MaxNorm(D);
	    int[] base = new int[n];
	    Arrays.fill(base,1);

	    for(int i=0;i<n;i++)
		z_data[i][0] = tmp[i];
	    
	    Matrix z = new Matrix(z_data);
	    //z.print(1,1);
	    double norm_2 = -1;
	    double total = 0;
	    double ratio = 0;
	    double min = 100;
	    while(MyUtil.e_norm_2(D,z) > n+1){
		B = MyUtil.ellipsoid_expand(D,z);
		D = MyUtil.ellipsoid_allign(B); 
		tmp = submo.MaxNorm(D);
		
		{//|}gCh͂ݏoĂʑ̏ɖ߂
		    total = MyUtil.array_sum(tmp);
		    if(submo.getValue(base) < total){
			ratio = submo.getValue(base)/total; 
			//System.out.println("ration = "+ratio);
			for(int i=0;i<n;i++)
			    tmp[i] *= ratio;
		    }
		}
		
		for(int i=0;i<n;i++)
		    z_data[i][0] = tmp[i];
		
		z = new Matrix(z_data);
		j++;
		loopnum++;

		norm_2 = MyUtil.e_norm_2(D,z);
		//System.out.println(Math.sqrt(Math.pow(l/(n*1.0),n)*Math.pow((n-1)/((l-1)*1.0),n-1)));
		//prevnorm = MyUtil.e_norm_2(D,z);
		//System.out.println(MyUtil.e_norm_2(D,z));
	    }
	    //z.print(6,6);
	    //submo.print();
	    fhat.setValue(D);
	    //	    System.out.println(Arrays.toString(tmp));
	    //fhat.print();
	    //System.out.println("loop count = " + loopnum);
	    System.out.println("approximation raio = " + submo.getApproxRate(fhat));
	    //submo.print();
	    //fhat.print();
	    //D.print(6,6);
	    
	    stop = System.currentTimeMillis();
	    diff = stop - start;
	    System.out.print(loopnum);
	    System.out.print(",");
	    System.out.print(diff);
	    System.out.print(",");
	    System.out.println(l);
	    int[] apptest = new int[l];
	    double rate=0;
	    /**
	    for(int i=0;i<l;i++){
		apptest[i] = 1;
		rate = Math.max(rate,submo.getValue(apptest)/fhat.getValue(apptest));
		min = Math.min(min,submo.getValue(apptest)/fhat.getValue(apptest));
		apptest[i] = 0;
	    }
	    **/
	    //z.print(1,10);
	    //fhat.print();
	    //System.out.println("approxrate = "+rate+"  ratio ="+ratio+"   min  ="+min);
	    //	    System.out.println("s : "+diff+"~b"+" n="+l);
	    }
    }
}
}