/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import java.util.Arrays;

public class MyUtil {
    public static double array_sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static int array_sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static int[] array_intersect(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return new int[0];
        }
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || nArray2[i] == 0) continue;
            nArray3[i] = 1;
        }
        return nArray3;
    }

    public static int[] array_union(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return new int[0];
        }
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 && nArray2[i] == 0) continue;
            nArray3[i] = 1;
        }
        return nArray3;
    }

    public static int[] asort(double[] dArray) {
        int n;
        int n2 = dArray.length;
        int[] nArray = new int[n2];
        double[] dArray2 = (double[])dArray.clone();
        boolean[] blArray = new boolean[n2];
        Arrays.sort(dArray2);
        block0: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (dArray2[n] != dArray[i] || blArray[i]) continue;
                nArray[n] = i;
                blArray[i] = true;
                continue block0;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray2[n];
        }
        return nArray;
    }

    public static void reverse(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[dArray.length - n - 1] = dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = dArray2[n];
        }
    }

    public static void reverse(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[nArray.length - n - 1] = nArray[n];
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = nArray2[n];
        }
    }

    public static double e_norm_2(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = matrix2.transpose();
        Matrix matrix4 = matrix3.times(matrix);
        matrix4 = matrix4.times(matrix2);
        return matrix4.get(0, 0);
    }

    public static Matrix make_first_ellipsoid(Submodular submodular) {
        int n = submodular.getSize();
        Matrix matrix = new Matrix(n, n);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1;
            matrix.set(i, i, (double)n / Math.pow(submodular.getValue(nArray), 2.0));
            nArray[i] = 0;
        }
        return matrix;
    }

    public static boolean next_combination(int[] nArray) {
        int n = 0;
        boolean bl = false;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (bl && nArray[i] == 1) {
                nArray[i + 1] = 1;
                nArray[i] = 0;
                for (int j = i + 2; j < nArray.length; ++j) {
                    nArray[j] = j <= i + n + 1 ? 1 : 0;
                }
                return true;
            }
            if (nArray[i] == 1) {
                ++n;
                continue;
            }
            bl = true;
        }
        return false;
    }

    public static boolean all_combination(int[] nArray) {
        int n;
        int n2 = 0;
        if (MyUtil.next_combination(nArray)) {
            return true;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != 1) continue;
            ++n2;
        }
        if (n2 == nArray.length) {
            return false;
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n < n2 + 1 ? 1 : 0;
        }
        return true;
    }

    public static Matrix ellipsoid_expand(Matrix matrix, Matrix matrix2) {
        int n = matrix2.getRowDimension();
        double d = MyUtil.e_norm_2(matrix, matrix2);
        Matrix matrix3 = matrix.times((double)n * (d - 1.0) / (d * (double)(n - 1)));
        Matrix matrix4 = matrix.times(matrix2);
        matrix4 = matrix4.times(matrix2.transpose());
        matrix4 = matrix4.times(matrix);
        matrix3 = matrix3.plus(matrix4.times((double)n / (d * d) * (1.0 - (d - 1.0) / (double)(n - 1) * 1.0)));
        return matrix3;
    }

    public static Matrix ellipsoid_allign(Matrix matrix) {
        int n = matrix.getRowDimension();
        Matrix matrix2 = new Matrix(n, n);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        Matrix matrix3 = matrix.inverse();
        for (int i = 0; i < n; ++i) {
            matrix2.set(i, i, matrix3.get(i, i));
        }
        return matrix2.inverse();
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 0, 0, 0, 0, 0, 0};
        do {
            System.out.println(Arrays.toString(nArray));
        } while (MyUtil.all_combination(nArray));
        double[] dArray = new double[]{1.0, 5.0, 4.0, 6.0, 8.0, 3.0, 9.0, 0.0};
        System.out.println(Arrays.toString(MyUtil.asort(dArray)));
        System.out.println(Arrays.toString(dArray));
    }
}

