/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;

public class GraphicMatroid
extends Submodular {
    Matrix mat;

    public double getValue(int[] nArray) {
        int n = 0;
        if (nArray.length != this.size) {
            return -1.0;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            ++n;
        }
        if (n == 0) {
            return 0.0;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            nArray2[n2] = i;
            ++n2;
        }
        Matrix matrix = this.mat.getMatrix(0, this.size - 1, nArray2);
        return matrix.rank();
    }

    GraphicMatroid(int n) {
        super(n);
        int n2;
        int n3;
        int n4;
        this.mat = new Matrix(n, n);
        for (n4 = 0; n4 < n; ++n4) {
            n3 = (int)(Math.random() * (double)n);
            n2 = (int)(Math.random() * (double)n);
            if (n2 != n3) {
                this.mat.set(n3, n4, 1.0);
                this.mat.set(n2, n4, -1.0);
                continue;
            }
            --n4;
        }
        for (n4 = n; n4 < n; ++n4) {
            n3 = (int)(Math.random() * (double)n);
            n2 = (int)(Math.random() * (double)n);
            if (n2 != n3) {
                this.mat.set(n3, n4, 1.0);
                this.mat.set(n2, n4, -1.0);
                continue;
            }
            --n4;
        }
        double[][] dArray = new double[n][this.mat.getRowDimension()];
        dArray = this.mat.getArray();
    }

    public void print() {
        this.mat.print(0, 0);
    }

    public static void main(String[] stringArray) {
        int n = 71;
        GraphicMatroid graphicMatroid = new GraphicMatroid(n);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.round(Math.random());
            nArray2[i] = (int)Math.round(Math.random());
        }
        int[] nArray3 = MyUtil.array_intersect(nArray, nArray2);
        int[] nArray4 = MyUtil.array_union(nArray, nArray2);
        int[] nArray5 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray5[i] = 1;
        }
    }
}

