import java.io.*;

class Graph {
    GraphList[] list;
    int[] fmap;

    Graph(int f){
	int size = f;
	list = new GraphList[size];
	for(int i=0;i<size;i++){
	    list[i] = new GraphList(i);
	}
	fmap = new int[size];
    }
    public int getIdByAxisCoor(int axis,int coor){
	for(int i=0;i<list.length;i++){
	    if(list[i].axis == axis && list[i].coor == coor)
		return list[i].id;
	}
	return -1;
    }
    public void connect(int x, int y) {
	GraphList t = list[x];
	GraphList u = null;
	while(t != null) {
	    if (t.id == y) return;
	    u = t;
	    t = t.next;
	}
	if (u == null) list[x] = new GraphList(y);
	else u.next = new GraphList(y) ;
    }

    public boolean connected(int x,int y) {
	GraphList t = list[x];
	while(t != null) {
	    if (t.id == y) return true;
	    t = t.next;
	}
	return false;
    }

    public int size() {
	return list.length-1;
    }

    public void dump() {
	for (int i = 0; i < list.length; i++) {
	    System.out.print(i+":");
	    GraphList t = list[i];
	    while (t != null) {
		if(t.id != i)
		    System.out.print(" "+t.id);
		t = t.next;
	    }
	    System.out.println();
	}
    }

    public void travx(int from, int d, int to) {
	if (d == to) {
	    trace(to,from);
	    return;
	}
	for (int i = 0; i < this.list.length; i++) {
	    if (this.connected(d,i) && fmap[i] == 0) {
		fmap[i] = d;
		travx(from,i,to);
	    }
	}
    }

    public void trace(int from, int to) {
	for (; from != to; from = fmap[from]) System.out.print(from+" ");
	System.out.println(from);
    }

    public static void main(String[] args) {
    }
}
