import Jama.*;
import java.util.*;
import java.io.*;
public class GraphicMatroid extends Submodular{
 
    Matrix mat;
    public double getValue(int[] subset){
	int minorsize=0;
	if(subset.length != size){
	    return (double)-1;
	}

	for(int i=0;i<subset.length;i++)
	    if(subset[i] == 1)
		minorsize++;
        if(minorsize == 0)
	    return 0;
	int[] minormat = new int[minorsize];
	for(int i=0,j=0;i<subset.length;i++){
	    if(subset[i] == 1){
		minormat[j] = i;
		j++;
	    }
	}
	
	Matrix tmp = mat.getMatrix(0,size-1,minormat);
	//tmp.print(1,1);
	return (double)tmp.rank();
    }

    GraphicMatroid(int size){
	super(size);
	mat = new Matrix(size,size);
	int j,k;
	double[][] array; 
	for(int i=0;i<size;i++){
	    j=(int)(Math.random()*size);
	    k=(int)(Math.random()*size);
	    if(k != j){ 
		mat.set(j,i,1);
		mat.set(k,i,-1);
	    }else{
		i--;
	    }
	}

	for(int i=size;i<size;i++){
	    /*
	      int l  = (int)Math.round(Math.random());
	      if(l == 0)
	      continue;
	    */
	    j=(int)(Math.random()*size);
	    k=(int)(Math.random()*size);
	    if(k != j){ 
		mat.set(j,i,1);
		mat.set(k,i,-1);
	    }else{
		i--;
	    }
	}
	array = new double[size][mat.getRowDimension()]; 
	array = mat.getArray();
	//System.out.println(Arrays.deepToString(array));
	/**
	String[] cmdarray = {"php","drawGraph.php", "'",Arrays.deepToString(array),"'" ,">/cygdrive/c/shuron/program/graph.gif"};
	//System.out.println(cmdarray[0]+cmdarray[1]+cmdarray[2]+cmdarray[3]+cmdarray[4]);
	try{
	    Process process =  Runtime.getRuntime().exec(cmdarray);
	    InputStream is = process.getInputStream();
	    BufferedReader br = new BufferedReader(new InputStreamReader(is));
	    String line;
	    while ((line = br.readLine()) != null) {
		System.out.println(line);
		// line ŉB
	    }

	}catch(Exception e){
	    e.printStackTrace();
	}
	**/
	//System.out.println(mat.toString());
    }
    public void print(){
	mat.print(0,0);
    }


    
    public static void main(String[] args){
	int n=71;
	GraphicMatroid ms = new GraphicMatroid(n);

	int[] set = new int[n];
	int[] subset = new int[n];
	for(int i=0;i<n;i++){
	    set[i] = (int)Math.round(Math.random());
	    subset[i] = (int) Math.round(Math.random());
	}
	int[] xx = MyUtil.array_intersect(set,subset);
	int[] yy = MyUtil.array_union(set,subset);

	int[] testset = new int[n];
	for(int i=0;i<n;i++){
	    testset[i] = 1;
	    //System.out.println(ms.getValue(testset));
	}
	//System.out.println(ms.getValue(set)+ms.getValue(subset)-ms.getValue(xx)-ms.getValue(yy));
    }

}
