/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import java.util.Arrays;

abstract class Submodular {
    int size;
    double beta;

    public abstract double getValue(int[] var1);

    public abstract void print();

    Submodular(int n) {
        this.size = n;
    }

    public double[] MaxNorm(Matrix matrix) {
        int n;
        double d = 0.0;
        double[] dArray = new double[this.size];
        double[] dArray2 = new double[this.size];
        int[] nArray = new int[this.size];
        int[] nArray2 = new int[this.size];
        for (n = 0; n < this.size; ++n) {
            dArray2[n] = matrix.get(n, n);
        }
        for (n = 0; n < this.size; ++n) {
            int n2 = -1;
            double d2 = 0.0;
            for (int i = 0; i < this.size; ++i) {
                if (nArray2[i] != 0) continue;
                nArray2[i] = 1;
                if (d2 < this.getGValue(dArray2, nArray2) - d) {
                    n2 = i;
                    d2 = this.getGValue(dArray2, nArray2) - d;
                }
                nArray2[i] = 0;
            }
            if (!(d2 > 0.0)) continue;
            nArray2[n2] = 1;
            dArray[n2] = this.getGValue(dArray2, nArray2) - d;
            d = this.getGValue(dArray2, nArray2);
        }
        for (n = 0; n < this.size; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] / dArray2[n];
        }
        return dArray;
    }

    public double getApproxRate(Submodular submodular) {
        double d = 0.0;
        int[] nArray = new int[this.size];
        Arrays.fill(nArray, 0);
        nArray[0] = 1;
        int[] nArray2 = new int[this.size];
        boolean bl = false;
        do {
            if (submodular.getValue(nArray) > this.getValue(nArray)) {
                return -1.0;
            }
            if (!(d < this.getValue(nArray) / submodular.getValue(nArray))) continue;
            d = this.getValue(nArray) / submodular.getValue(nArray);
            for (int i = 0; i < this.size; ++i) {
                nArray2[i] = nArray[i];
            }
        } while (MyUtil.all_combination(nArray));
        return d;
    }

    public int getSize() {
        return this.size;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 4.0, 0.0}, {0.0, 0.0, 9.0}};
        Matrix matrix = new Matrix(dArrayArray);
    }

    public double _getValue(int[] nArray) {
        return 0.0;
    }

    public double toMonotone(int[] nArray) {
        int[] nArray2 = new int[this.size];
        Arrays.fill(nArray2, 1);
        double d = this._getValue(nArray);
        for (int i = 0; i < this.size; ++i) {
            if (nArray[i] != 1) continue;
            nArray2[i] = 0;
            d += this._getValue(nArray2);
            nArray2[i] = 1;
            d -= this._getValue(nArray2);
        }
        return d;
    }

    public double getGValue(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[this.size];
        double d = 0.0;
        int[] nArray2 = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            dArray2[i] = dArray[i];
        }
        int[] nArray3 = MyUtil.asort(dArray2);
        for (int i = this.size - 1; i > 0; --i) {
            if (nArray[nArray3[i]] != 1) continue;
            d -= dArray2[i] * this.getValue(nArray2);
            nArray2[nArray3[i]] = 1;
            d += dArray2[i] * this.getValue(nArray2);
        }
        return d;
    }
}

